<?php

namespace tk_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Stock ServiceType
 * @subpackage Services
 */
class Stock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StockListAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nonZeroOnly
     * @param string $lastCode
     * @return \tk_\StructType\TStoreStockType[]|bool
     */
    public function StockListAll($nonZeroOnly, $lastCode)
    {
        try {
            $this->setResult($this->getSoapClient()->StockListAll($nonZeroOnly, $lastCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StockList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nonZeroOnly
     * @return \tk_\StructType\TStockType[]|bool
     */
    public function StockList($nonZeroOnly)
    {
        try {
            $this->setResult($this->getSoapClient()->StockList($nonZeroOnly));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StockListColourSize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $nonZeroOnly
     * @return \tk_\StructType\TStockType[]|bool
     */
    public function StockListColourSize($nonZeroOnly)
    {
        try {
            $this->setResult($this->getSoapClient()->StockListColourSize($nonZeroOnly));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StockAvailable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $itemCode
     * @param string $colourCode
     * @param string $sizeCode
     * @return \tk_\StructType\TStockAvailableType[]|bool
     */
    public function StockAvailable($itemCode, $colourCode, $sizeCode)
    {
        try {
            $this->setResult($this->getSoapClient()->StockAvailable($itemCode, $colourCode, $sizeCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \tk_\StructType\TStockAvailableType[]|\tk_\StructType\TStockType[]|\tk_\StructType\TStoreStockType[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
