<?php

namespace tk_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Custom ServiceType
 * @subpackage Services
 */
class Custom extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $query
     * @return string[]|bool
     */
    public function CustomQuery($query)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomQuery($query));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
