<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TTender StructType
 * @subpackage Structs
 */
class TTender extends AbstractStructBase
{
    /**
     * The Tender
     * @var string
     */
    public $Tender;
    /**
     * The Reference
     * @var string
     */
    public $Reference;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for TTender
     * @uses TTender::setTender()
     * @uses TTender::setReference()
     * @uses TTender::setAmount()
     * @param string $tender
     * @param string $reference
     * @param float $amount
     */
    public function __construct($tender = null, $reference = null, $amount = null)
    {
        $this
            ->setTender($tender)
            ->setReference($reference)
            ->setAmount($amount);
    }
    /**
     * Get Tender value
     * @return string|null
     */
    public function getTender()
    {
        return $this->Tender;
    }
    /**
     * Set Tender value
     * @param string $tender
     * @return \tk_\StructType\TTender
     */
    public function setTender($tender = null)
    {
        // validation for constraint: string
        if (!is_null($tender) && !is_string($tender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tender, true), gettype($tender)), __LINE__);
        }
        $this->Tender = $tender;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \tk_\StructType\TTender
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \tk_\StructType\TTender
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
