<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStockType StructType
 * @subpackage Structs
 */
class TStockType extends AbstractStructBase
{
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The FullDescription
     * @var string
     */
    public $FullDescription;
    /**
     * The Category1
     * @var string
     */
    public $Category1;
    /**
     * The Category2
     * @var string
     */
    public $Category2;
    /**
     * The Category3
     * @var string
     */
    public $Category3;
    /**
     * The Category4
     * @var string
     */
    public $Category4;
    /**
     * The Userfield1
     * @var string
     */
    public $Userfield1;
    /**
     * The Userfield2
     * @var string
     */
    public $Userfield2;
    /**
     * The Brand
     * @var string
     */
    public $Brand;
    /**
     * The StoreID
     * @var string
     */
    public $StoreID;
    /**
     * The ColourCode
     * @var string
     */
    public $ColourCode;
    /**
     * The ColourDescription
     * @var string
     */
    public $ColourDescription;
    /**
     * The SizeCode
     * @var string
     */
    public $SizeCode;
    /**
     * The SizeDescription
     * @var string
     */
    public $SizeDescription;
    /**
     * The QtyAvailable
     * @var float
     */
    public $QtyAvailable;
    /**
     * The ExclSellPrice
     * @var float
     */
    public $ExclSellPrice;
    /**
     * The InclSellPrice
     * @var float
     */
    public $InclSellPrice;
    /**
     * The ExclPromoPrice
     * @var float
     */
    public $ExclPromoPrice;
    /**
     * The InclPromoPrice
     * @var float
     */
    public $InclPromoPrice;
    /**
     * The AliasCode
     * @var string
     */
    public $AliasCode;
    /**
     * The Image
     * @var string
     */
    public $Image;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * Constructor method for TStockType
     * @uses TStockType::setItemCode()
     * @uses TStockType::setDescription()
     * @uses TStockType::setFullDescription()
     * @uses TStockType::setCategory1()
     * @uses TStockType::setCategory2()
     * @uses TStockType::setCategory3()
     * @uses TStockType::setCategory4()
     * @uses TStockType::setUserfield1()
     * @uses TStockType::setUserfield2()
     * @uses TStockType::setBrand()
     * @uses TStockType::setStoreID()
     * @uses TStockType::setColourCode()
     * @uses TStockType::setColourDescription()
     * @uses TStockType::setSizeCode()
     * @uses TStockType::setSizeDescription()
     * @uses TStockType::setQtyAvailable()
     * @uses TStockType::setExclSellPrice()
     * @uses TStockType::setInclSellPrice()
     * @uses TStockType::setExclPromoPrice()
     * @uses TStockType::setInclPromoPrice()
     * @uses TStockType::setAliasCode()
     * @uses TStockType::setImage()
     * @uses TStockType::setNote()
     * @param string $itemCode
     * @param string $description
     * @param string $fullDescription
     * @param string $category1
     * @param string $category2
     * @param string $category3
     * @param string $category4
     * @param string $userfield1
     * @param string $userfield2
     * @param string $brand
     * @param string $storeID
     * @param string $colourCode
     * @param string $colourDescription
     * @param string $sizeCode
     * @param string $sizeDescription
     * @param float $qtyAvailable
     * @param float $exclSellPrice
     * @param float $inclSellPrice
     * @param float $exclPromoPrice
     * @param float $inclPromoPrice
     * @param string $aliasCode
     * @param string $image
     * @param string $note
     */
    public function __construct($itemCode = null, $description = null, $fullDescription = null, $category1 = null, $category2 = null, $category3 = null, $category4 = null, $userfield1 = null, $userfield2 = null, $brand = null, $storeID = null, $colourCode = null, $colourDescription = null, $sizeCode = null, $sizeDescription = null, $qtyAvailable = null, $exclSellPrice = null, $inclSellPrice = null, $exclPromoPrice = null, $inclPromoPrice = null, $aliasCode = null, $image = null, $note = null)
    {
        $this
            ->setItemCode($itemCode)
            ->setDescription($description)
            ->setFullDescription($fullDescription)
            ->setCategory1($category1)
            ->setCategory2($category2)
            ->setCategory3($category3)
            ->setCategory4($category4)
            ->setUserfield1($userfield1)
            ->setUserfield2($userfield2)
            ->setBrand($brand)
            ->setStoreID($storeID)
            ->setColourCode($colourCode)
            ->setColourDescription($colourDescription)
            ->setSizeCode($sizeCode)
            ->setSizeDescription($sizeDescription)
            ->setQtyAvailable($qtyAvailable)
            ->setExclSellPrice($exclSellPrice)
            ->setInclSellPrice($inclSellPrice)
            ->setExclPromoPrice($exclPromoPrice)
            ->setInclPromoPrice($inclPromoPrice)
            ->setAliasCode($aliasCode)
            ->setImage($image)
            ->setNote($note);
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \tk_\StructType\TStockType
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \tk_\StructType\TStockType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FullDescription value
     * @return string|null
     */
    public function getFullDescription()
    {
        return $this->FullDescription;
    }
    /**
     * Set FullDescription value
     * @param string $fullDescription
     * @return \tk_\StructType\TStockType
     */
    public function setFullDescription($fullDescription = null)
    {
        // validation for constraint: string
        if (!is_null($fullDescription) && !is_string($fullDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullDescription, true), gettype($fullDescription)), __LINE__);
        }
        $this->FullDescription = $fullDescription;
        return $this;
    }
    /**
     * Get Category1 value
     * @return string|null
     */
    public function getCategory1()
    {
        return $this->Category1;
    }
    /**
     * Set Category1 value
     * @param string $category1
     * @return \tk_\StructType\TStockType
     */
    public function setCategory1($category1 = null)
    {
        // validation for constraint: string
        if (!is_null($category1) && !is_string($category1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category1, true), gettype($category1)), __LINE__);
        }
        $this->Category1 = $category1;
        return $this;
    }
    /**
     * Get Category2 value
     * @return string|null
     */
    public function getCategory2()
    {
        return $this->Category2;
    }
    /**
     * Set Category2 value
     * @param string $category2
     * @return \tk_\StructType\TStockType
     */
    public function setCategory2($category2 = null)
    {
        // validation for constraint: string
        if (!is_null($category2) && !is_string($category2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category2, true), gettype($category2)), __LINE__);
        }
        $this->Category2 = $category2;
        return $this;
    }
    /**
     * Get Category3 value
     * @return string|null
     */
    public function getCategory3()
    {
        return $this->Category3;
    }
    /**
     * Set Category3 value
     * @param string $category3
     * @return \tk_\StructType\TStockType
     */
    public function setCategory3($category3 = null)
    {
        // validation for constraint: string
        if (!is_null($category3) && !is_string($category3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category3, true), gettype($category3)), __LINE__);
        }
        $this->Category3 = $category3;
        return $this;
    }
    /**
     * Get Category4 value
     * @return string|null
     */
    public function getCategory4()
    {
        return $this->Category4;
    }
    /**
     * Set Category4 value
     * @param string $category4
     * @return \tk_\StructType\TStockType
     */
    public function setCategory4($category4 = null)
    {
        // validation for constraint: string
        if (!is_null($category4) && !is_string($category4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category4, true), gettype($category4)), __LINE__);
        }
        $this->Category4 = $category4;
        return $this;
    }
    /**
     * Get Userfield1 value
     * @return string|null
     */
    public function getUserfield1()
    {
        return $this->Userfield1;
    }
    /**
     * Set Userfield1 value
     * @param string $userfield1
     * @return \tk_\StructType\TStockType
     */
    public function setUserfield1($userfield1 = null)
    {
        // validation for constraint: string
        if (!is_null($userfield1) && !is_string($userfield1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userfield1, true), gettype($userfield1)), __LINE__);
        }
        $this->Userfield1 = $userfield1;
        return $this;
    }
    /**
     * Get Userfield2 value
     * @return string|null
     */
    public function getUserfield2()
    {
        return $this->Userfield2;
    }
    /**
     * Set Userfield2 value
     * @param string $userfield2
     * @return \tk_\StructType\TStockType
     */
    public function setUserfield2($userfield2 = null)
    {
        // validation for constraint: string
        if (!is_null($userfield2) && !is_string($userfield2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userfield2, true), gettype($userfield2)), __LINE__);
        }
        $this->Userfield2 = $userfield2;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \tk_\StructType\TStockType
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get StoreID value
     * @return string|null
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \tk_\StructType\TStockType
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeID, true), gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get ColourCode value
     * @return string|null
     */
    public function getColourCode()
    {
        return $this->ColourCode;
    }
    /**
     * Set ColourCode value
     * @param string $colourCode
     * @return \tk_\StructType\TStockType
     */
    public function setColourCode($colourCode = null)
    {
        // validation for constraint: string
        if (!is_null($colourCode) && !is_string($colourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colourCode, true), gettype($colourCode)), __LINE__);
        }
        $this->ColourCode = $colourCode;
        return $this;
    }
    /**
     * Get ColourDescription value
     * @return string|null
     */
    public function getColourDescription()
    {
        return $this->ColourDescription;
    }
    /**
     * Set ColourDescription value
     * @param string $colourDescription
     * @return \tk_\StructType\TStockType
     */
    public function setColourDescription($colourDescription = null)
    {
        // validation for constraint: string
        if (!is_null($colourDescription) && !is_string($colourDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colourDescription, true), gettype($colourDescription)), __LINE__);
        }
        $this->ColourDescription = $colourDescription;
        return $this;
    }
    /**
     * Get SizeCode value
     * @return string|null
     */
    public function getSizeCode()
    {
        return $this->SizeCode;
    }
    /**
     * Set SizeCode value
     * @param string $sizeCode
     * @return \tk_\StructType\TStockType
     */
    public function setSizeCode($sizeCode = null)
    {
        // validation for constraint: string
        if (!is_null($sizeCode) && !is_string($sizeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeCode, true), gettype($sizeCode)), __LINE__);
        }
        $this->SizeCode = $sizeCode;
        return $this;
    }
    /**
     * Get SizeDescription value
     * @return string|null
     */
    public function getSizeDescription()
    {
        return $this->SizeDescription;
    }
    /**
     * Set SizeDescription value
     * @param string $sizeDescription
     * @return \tk_\StructType\TStockType
     */
    public function setSizeDescription($sizeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($sizeDescription) && !is_string($sizeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeDescription, true), gettype($sizeDescription)), __LINE__);
        }
        $this->SizeDescription = $sizeDescription;
        return $this;
    }
    /**
     * Get QtyAvailable value
     * @return float|null
     */
    public function getQtyAvailable()
    {
        return $this->QtyAvailable;
    }
    /**
     * Set QtyAvailable value
     * @param float $qtyAvailable
     * @return \tk_\StructType\TStockType
     */
    public function setQtyAvailable($qtyAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($qtyAvailable) && !(is_float($qtyAvailable) || is_numeric($qtyAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyAvailable, true), gettype($qtyAvailable)), __LINE__);
        }
        $this->QtyAvailable = $qtyAvailable;
        return $this;
    }
    /**
     * Get ExclSellPrice value
     * @return float|null
     */
    public function getExclSellPrice()
    {
        return $this->ExclSellPrice;
    }
    /**
     * Set ExclSellPrice value
     * @param float $exclSellPrice
     * @return \tk_\StructType\TStockType
     */
    public function setExclSellPrice($exclSellPrice = null)
    {
        // validation for constraint: float
        if (!is_null($exclSellPrice) && !(is_float($exclSellPrice) || is_numeric($exclSellPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exclSellPrice, true), gettype($exclSellPrice)), __LINE__);
        }
        $this->ExclSellPrice = $exclSellPrice;
        return $this;
    }
    /**
     * Get InclSellPrice value
     * @return float|null
     */
    public function getInclSellPrice()
    {
        return $this->InclSellPrice;
    }
    /**
     * Set InclSellPrice value
     * @param float $inclSellPrice
     * @return \tk_\StructType\TStockType
     */
    public function setInclSellPrice($inclSellPrice = null)
    {
        // validation for constraint: float
        if (!is_null($inclSellPrice) && !(is_float($inclSellPrice) || is_numeric($inclSellPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inclSellPrice, true), gettype($inclSellPrice)), __LINE__);
        }
        $this->InclSellPrice = $inclSellPrice;
        return $this;
    }
    /**
     * Get ExclPromoPrice value
     * @return float|null
     */
    public function getExclPromoPrice()
    {
        return $this->ExclPromoPrice;
    }
    /**
     * Set ExclPromoPrice value
     * @param float $exclPromoPrice
     * @return \tk_\StructType\TStockType
     */
    public function setExclPromoPrice($exclPromoPrice = null)
    {
        // validation for constraint: float
        if (!is_null($exclPromoPrice) && !(is_float($exclPromoPrice) || is_numeric($exclPromoPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exclPromoPrice, true), gettype($exclPromoPrice)), __LINE__);
        }
        $this->ExclPromoPrice = $exclPromoPrice;
        return $this;
    }
    /**
     * Get InclPromoPrice value
     * @return float|null
     */
    public function getInclPromoPrice()
    {
        return $this->InclPromoPrice;
    }
    /**
     * Set InclPromoPrice value
     * @param float $inclPromoPrice
     * @return \tk_\StructType\TStockType
     */
    public function setInclPromoPrice($inclPromoPrice = null)
    {
        // validation for constraint: float
        if (!is_null($inclPromoPrice) && !(is_float($inclPromoPrice) || is_numeric($inclPromoPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inclPromoPrice, true), gettype($inclPromoPrice)), __LINE__);
        }
        $this->InclPromoPrice = $inclPromoPrice;
        return $this;
    }
    /**
     * Get AliasCode value
     * @return string|null
     */
    public function getAliasCode()
    {
        return $this->AliasCode;
    }
    /**
     * Set AliasCode value
     * @param string $aliasCode
     * @return \tk_\StructType\TStockType
     */
    public function setAliasCode($aliasCode = null)
    {
        // validation for constraint: string
        if (!is_null($aliasCode) && !is_string($aliasCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasCode, true), gettype($aliasCode)), __LINE__);
        }
        $this->AliasCode = $aliasCode;
        return $this;
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param string $image
     * @return \tk_\StructType\TStockType
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \tk_\StructType\TStockType
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
}
