<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TGiftCardAuditDocument StructType
 * @subpackage Structs
 */
class TGiftCardAuditDocument extends AbstractStructBase
{
    /**
     * The Store
     * @var string
     */
    public $Store;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Time
     * @var string
     */
    public $Time;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for TGiftCardAuditDocument
     * @uses TGiftCardAuditDocument::setStore()
     * @uses TGiftCardAuditDocument::setDate()
     * @uses TGiftCardAuditDocument::setTime()
     * @uses TGiftCardAuditDocument::setDescription()
     * @uses TGiftCardAuditDocument::setAmount()
     * @param string $store
     * @param string $date
     * @param string $time
     * @param string $description
     * @param float $amount
     */
    public function __construct($store = null, $date = null, $time = null, $description = null, $amount = null)
    {
        $this
            ->setStore($store)
            ->setDate($date)
            ->setTime($time)
            ->setDescription($description)
            ->setAmount($amount);
    }
    /**
     * Get Store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->Store;
    }
    /**
     * Set Store value
     * @param string $store
     * @return \tk_\StructType\TGiftCardAuditDocument
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($store, true), gettype($store)), __LINE__);
        }
        $this->Store = $store;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \tk_\StructType\TGiftCardAuditDocument
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \tk_\StructType\TGiftCardAuditDocument
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \tk_\StructType\TGiftCardAuditDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \tk_\StructType\TGiftCardAuditDocument
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
