<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \tk_\ClassMap::get(),
);
/**
 * Samples for Status ServiceType
 */
$status = new \tk_\ServiceType\Status($options);
/**
 * Sample call for Status operation/method
 */
if ($status->Status() !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Stock ServiceType
 */
$stock = new \tk_\ServiceType\Stock($options);
/**
 * Sample call for StockListAll operation/method
 */
if ($stock->StockListAll($NonZeroOnly, $LastCode) !== false) {
    print_r($stock->getResult());
} else {
    print_r($stock->getLastError());
}
/**
 * Sample call for StockList operation/method
 */
if ($stock->StockList($NonZeroOnly) !== false) {
    print_r($stock->getResult());
} else {
    print_r($stock->getLastError());
}
/**
 * Sample call for StockListColourSize operation/method
 */
if ($stock->StockListColourSize($NonZeroOnly) !== false) {
    print_r($stock->getResult());
} else {
    print_r($stock->getLastError());
}
/**
 * Sample call for StockAvailable operation/method
 */
if ($stock->StockAvailable($ItemCode, $ColourCode, $SizeCode) !== false) {
    print_r($stock->getResult());
} else {
    print_r($stock->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \tk_\ServiceType\Get($options);
/**
 * Sample call for GetCustomer operation/method
 */
if ($get->GetCustomer($accountNo, $mobileNo) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetImage operation/method
 */
if ($get->GetImage($ItemCode) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNotes operation/method
 */
if ($get->GetNotes($ItemCode) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTenderTypes operation/method
 */
if ($get->GetTenderTypes() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \tk_\ServiceType\Add($options);
/**
 * Sample call for AddCustomer operation/method
 */
if ($add->AddCustomer(new \tk_\StructType\TCustomer()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSale operation/method
 */
if ($add->AddSale($AutoCreateCustomer, $OrderNumber, new \tk_\StructType\TCustomer(), $Items, $Tenders) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddRefund operation/method
 */
if ($add->AddRefund($AutoCreateCustomer, $OrderNumber, new \tk_\StructType\TCustomer(), $Items, $Tenders) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddOrder operation/method
 */
if ($add->AddOrder($AutoCreateCustomer, $OrderNumber, new \tk_\StructType\TCustomer(), $Items, $Tenders, $loyalty) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \tk_\ServiceType\Cancel($options);
/**
 * Sample call for CancelOrder operation/method
 */
if ($cancel->CancelOrder($OriginalOrderNumber, $Tenders) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Custom ServiceType
 */
$custom = new \tk_\ServiceType\Custom($options);
/**
 * Sample call for CustomQuery operation/method
 */
if ($custom->CustomQuery($Query) !== false) {
    print_r($custom->getResult());
} else {
    print_r($custom->getLastError());
}
/**
 * Samples for Gift ServiceType
 */
$gift = new \tk_\ServiceType\Gift($options);
/**
 * Sample call for GiftCardPurchase operation/method
 */
if ($gift->GiftCardPurchase() !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
/**
 * Sample call for GiftCardCancelPurchase operation/method
 */
if ($gift->GiftCardCancelPurchase($CardNumber) !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
/**
 * Sample call for GiftCardsAvailable operation/method
 */
if ($gift->GiftCardsAvailable() !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
/**
 * Sample call for GiftCardBalance operation/method
 */
if ($gift->GiftCardBalance($CardNumber) !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
/**
 * Sample call for GiftCardAudit operation/method
 */
if ($gift->GiftCardAudit($CardNumber) !== false) {
    print_r($gift->getResult());
} else {
    print_r($gift->getLastError());
}
