<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStoreStockType StructType
 * @subpackage Structs
 */
class TStoreStockType extends AbstractStructBase
{
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The FullDescription
     * @var string
     */
    public $FullDescription;
    /**
     * The Category1
     * @var string
     */
    public $Category1;
    /**
     * The Category2
     * @var string
     */
    public $Category2;
    /**
     * The Category3
     * @var string
     */
    public $Category3;
    /**
     * The Category4
     * @var string
     */
    public $Category4;
    /**
     * The Userfield1
     * @var string
     */
    public $Userfield1;
    /**
     * The Userfield2
     * @var string
     */
    public $Userfield2;
    /**
     * The Brand
     * @var string
     */
    public $Brand;
    /**
     * The ExclSellPrice
     * @var float
     */
    public $ExclSellPrice;
    /**
     * The InclSellPrice
     * @var float
     */
    public $InclSellPrice;
    /**
     * The ExclPromoPrice
     * @var float
     */
    public $ExclPromoPrice;
    /**
     * The InclPromoPrice
     * @var float
     */
    public $InclPromoPrice;
    /**
     * The AliasCode
     * @var string
     */
    public $AliasCode;
    /**
     * The Image
     * @var string
     */
    public $Image;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * The Sizes
     * Meta information extracted from the WSDL
     * - arrayType: ns1:TSize[]
     * - base: soapenc:Array
     * - ref: soapenc:arrayType
     * @var \tk_\StructType\TSize[]
     */
    public $Sizes;
    /**
     * Constructor method for TStoreStockType
     * @uses TStoreStockType::setItemCode()
     * @uses TStoreStockType::setDescription()
     * @uses TStoreStockType::setFullDescription()
     * @uses TStoreStockType::setCategory1()
     * @uses TStoreStockType::setCategory2()
     * @uses TStoreStockType::setCategory3()
     * @uses TStoreStockType::setCategory4()
     * @uses TStoreStockType::setUserfield1()
     * @uses TStoreStockType::setUserfield2()
     * @uses TStoreStockType::setBrand()
     * @uses TStoreStockType::setExclSellPrice()
     * @uses TStoreStockType::setInclSellPrice()
     * @uses TStoreStockType::setExclPromoPrice()
     * @uses TStoreStockType::setInclPromoPrice()
     * @uses TStoreStockType::setAliasCode()
     * @uses TStoreStockType::setImage()
     * @uses TStoreStockType::setNote()
     * @uses TStoreStockType::setSizes()
     * @param string $itemCode
     * @param string $description
     * @param string $fullDescription
     * @param string $category1
     * @param string $category2
     * @param string $category3
     * @param string $category4
     * @param string $userfield1
     * @param string $userfield2
     * @param string $brand
     * @param float $exclSellPrice
     * @param float $inclSellPrice
     * @param float $exclPromoPrice
     * @param float $inclPromoPrice
     * @param string $aliasCode
     * @param string $image
     * @param string $note
     * @param \tk_\StructType\TSize[] $sizes
     */
    public function __construct($itemCode = null, $description = null, $fullDescription = null, $category1 = null, $category2 = null, $category3 = null, $category4 = null, $userfield1 = null, $userfield2 = null, $brand = null, $exclSellPrice = null, $inclSellPrice = null, $exclPromoPrice = null, $inclPromoPrice = null, $aliasCode = null, $image = null, $note = null, array $sizes = array())
    {
        $this
            ->setItemCode($itemCode)
            ->setDescription($description)
            ->setFullDescription($fullDescription)
            ->setCategory1($category1)
            ->setCategory2($category2)
            ->setCategory3($category3)
            ->setCategory4($category4)
            ->setUserfield1($userfield1)
            ->setUserfield2($userfield2)
            ->setBrand($brand)
            ->setExclSellPrice($exclSellPrice)
            ->setInclSellPrice($inclSellPrice)
            ->setExclPromoPrice($exclPromoPrice)
            ->setInclPromoPrice($inclPromoPrice)
            ->setAliasCode($aliasCode)
            ->setImage($image)
            ->setNote($note)
            ->setSizes($sizes);
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \tk_\StructType\TStoreStockType
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \tk_\StructType\TStoreStockType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FullDescription value
     * @return string|null
     */
    public function getFullDescription()
    {
        return $this->FullDescription;
    }
    /**
     * Set FullDescription value
     * @param string $fullDescription
     * @return \tk_\StructType\TStoreStockType
     */
    public function setFullDescription($fullDescription = null)
    {
        // validation for constraint: string
        if (!is_null($fullDescription) && !is_string($fullDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullDescription, true), gettype($fullDescription)), __LINE__);
        }
        $this->FullDescription = $fullDescription;
        return $this;
    }
    /**
     * Get Category1 value
     * @return string|null
     */
    public function getCategory1()
    {
        return $this->Category1;
    }
    /**
     * Set Category1 value
     * @param string $category1
     * @return \tk_\StructType\TStoreStockType
     */
    public function setCategory1($category1 = null)
    {
        // validation for constraint: string
        if (!is_null($category1) && !is_string($category1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category1, true), gettype($category1)), __LINE__);
        }
        $this->Category1 = $category1;
        return $this;
    }
    /**
     * Get Category2 value
     * @return string|null
     */
    public function getCategory2()
    {
        return $this->Category2;
    }
    /**
     * Set Category2 value
     * @param string $category2
     * @return \tk_\StructType\TStoreStockType
     */
    public function setCategory2($category2 = null)
    {
        // validation for constraint: string
        if (!is_null($category2) && !is_string($category2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category2, true), gettype($category2)), __LINE__);
        }
        $this->Category2 = $category2;
        return $this;
    }
    /**
     * Get Category3 value
     * @return string|null
     */
    public function getCategory3()
    {
        return $this->Category3;
    }
    /**
     * Set Category3 value
     * @param string $category3
     * @return \tk_\StructType\TStoreStockType
     */
    public function setCategory3($category3 = null)
    {
        // validation for constraint: string
        if (!is_null($category3) && !is_string($category3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category3, true), gettype($category3)), __LINE__);
        }
        $this->Category3 = $category3;
        return $this;
    }
    /**
     * Get Category4 value
     * @return string|null
     */
    public function getCategory4()
    {
        return $this->Category4;
    }
    /**
     * Set Category4 value
     * @param string $category4
     * @return \tk_\StructType\TStoreStockType
     */
    public function setCategory4($category4 = null)
    {
        // validation for constraint: string
        if (!is_null($category4) && !is_string($category4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category4, true), gettype($category4)), __LINE__);
        }
        $this->Category4 = $category4;
        return $this;
    }
    /**
     * Get Userfield1 value
     * @return string|null
     */
    public function getUserfield1()
    {
        return $this->Userfield1;
    }
    /**
     * Set Userfield1 value
     * @param string $userfield1
     * @return \tk_\StructType\TStoreStockType
     */
    public function setUserfield1($userfield1 = null)
    {
        // validation for constraint: string
        if (!is_null($userfield1) && !is_string($userfield1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userfield1, true), gettype($userfield1)), __LINE__);
        }
        $this->Userfield1 = $userfield1;
        return $this;
    }
    /**
     * Get Userfield2 value
     * @return string|null
     */
    public function getUserfield2()
    {
        return $this->Userfield2;
    }
    /**
     * Set Userfield2 value
     * @param string $userfield2
     * @return \tk_\StructType\TStoreStockType
     */
    public function setUserfield2($userfield2 = null)
    {
        // validation for constraint: string
        if (!is_null($userfield2) && !is_string($userfield2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userfield2, true), gettype($userfield2)), __LINE__);
        }
        $this->Userfield2 = $userfield2;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \tk_\StructType\TStoreStockType
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get ExclSellPrice value
     * @return float|null
     */
    public function getExclSellPrice()
    {
        return $this->ExclSellPrice;
    }
    /**
     * Set ExclSellPrice value
     * @param float $exclSellPrice
     * @return \tk_\StructType\TStoreStockType
     */
    public function setExclSellPrice($exclSellPrice = null)
    {
        // validation for constraint: float
        if (!is_null($exclSellPrice) && !(is_float($exclSellPrice) || is_numeric($exclSellPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exclSellPrice, true), gettype($exclSellPrice)), __LINE__);
        }
        $this->ExclSellPrice = $exclSellPrice;
        return $this;
    }
    /**
     * Get InclSellPrice value
     * @return float|null
     */
    public function getInclSellPrice()
    {
        return $this->InclSellPrice;
    }
    /**
     * Set InclSellPrice value
     * @param float $inclSellPrice
     * @return \tk_\StructType\TStoreStockType
     */
    public function setInclSellPrice($inclSellPrice = null)
    {
        // validation for constraint: float
        if (!is_null($inclSellPrice) && !(is_float($inclSellPrice) || is_numeric($inclSellPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inclSellPrice, true), gettype($inclSellPrice)), __LINE__);
        }
        $this->InclSellPrice = $inclSellPrice;
        return $this;
    }
    /**
     * Get ExclPromoPrice value
     * @return float|null
     */
    public function getExclPromoPrice()
    {
        return $this->ExclPromoPrice;
    }
    /**
     * Set ExclPromoPrice value
     * @param float $exclPromoPrice
     * @return \tk_\StructType\TStoreStockType
     */
    public function setExclPromoPrice($exclPromoPrice = null)
    {
        // validation for constraint: float
        if (!is_null($exclPromoPrice) && !(is_float($exclPromoPrice) || is_numeric($exclPromoPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exclPromoPrice, true), gettype($exclPromoPrice)), __LINE__);
        }
        $this->ExclPromoPrice = $exclPromoPrice;
        return $this;
    }
    /**
     * Get InclPromoPrice value
     * @return float|null
     */
    public function getInclPromoPrice()
    {
        return $this->InclPromoPrice;
    }
    /**
     * Set InclPromoPrice value
     * @param float $inclPromoPrice
     * @return \tk_\StructType\TStoreStockType
     */
    public function setInclPromoPrice($inclPromoPrice = null)
    {
        // validation for constraint: float
        if (!is_null($inclPromoPrice) && !(is_float($inclPromoPrice) || is_numeric($inclPromoPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inclPromoPrice, true), gettype($inclPromoPrice)), __LINE__);
        }
        $this->InclPromoPrice = $inclPromoPrice;
        return $this;
    }
    /**
     * Get AliasCode value
     * @return string|null
     */
    public function getAliasCode()
    {
        return $this->AliasCode;
    }
    /**
     * Set AliasCode value
     * @param string $aliasCode
     * @return \tk_\StructType\TStoreStockType
     */
    public function setAliasCode($aliasCode = null)
    {
        // validation for constraint: string
        if (!is_null($aliasCode) && !is_string($aliasCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aliasCode, true), gettype($aliasCode)), __LINE__);
        }
        $this->AliasCode = $aliasCode;
        return $this;
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param string $image
     * @return \tk_\StructType\TStoreStockType
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \tk_\StructType\TStoreStockType
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get Sizes value
     * @return \tk_\StructType\TSize[]|null
     */
    public function getSizes()
    {
        return $this->Sizes;
    }
    /**
     * This method is responsible for validating the values passed to the setSizes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSizes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSizesForArrayConstraintsFromSetSizes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tStoreStockTypeSizesItem) {
            // validation for constraint: itemType
            if (!$tStoreStockTypeSizesItem instanceof \tk_\StructType\TSize) {
                $invalidValues[] = is_object($tStoreStockTypeSizesItem) ? get_class($tStoreStockTypeSizesItem) : sprintf('%s(%s)', gettype($tStoreStockTypeSizesItem), var_export($tStoreStockTypeSizesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sizes property can only contain items of type \tk_\StructType\TSize, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sizes value
     * @throws \InvalidArgumentException
     * @param \tk_\StructType\TSize[] $sizes
     * @return \tk_\StructType\TStoreStockType
     */
    public function setSizes(array $sizes = array())
    {
        // validation for constraint: array
        if ('' !== ($sizesArrayErrorMessage = self::validateSizesForArrayConstraintsFromSetSizes($sizes))) {
            throw new \InvalidArgumentException($sizesArrayErrorMessage, __LINE__);
        }
        $this->Sizes = $sizes;
        return $this;
    }
    /**
     * Add item to Sizes value
     * @throws \InvalidArgumentException
     * @param \tk_\StructType\TSize $item
     * @return \tk_\StructType\TStoreStockType
     */
    public function addToSizes(\tk_\StructType\TSize $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \tk_\StructType\TSize) {
            throw new \InvalidArgumentException(sprintf('The Sizes property can only contain items of type \tk_\StructType\TSize, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sizes[] = $item;
        return $this;
    }
}
