<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStoreSOH StructType
 * @subpackage Structs
 */
class TStoreSOH extends AbstractStructBase
{
    /**
     * The ID
     * @var int
     */
    public $ID;
    /**
     * The Qty
     * @var float
     */
    public $Qty;
    /**
     * Constructor method for TStoreSOH
     * @uses TStoreSOH::setID()
     * @uses TStoreSOH::setQty()
     * @param int $iD
     * @param float $qty
     */
    public function __construct($iD = null, $qty = null)
    {
        $this
            ->setID($iD)
            ->setQty($qty);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \tk_\StructType\TStoreSOH
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \tk_\StructType\TStoreSOH
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
}
