<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStockSaleType StructType
 * @subpackage Structs
 */
class TStockSaleType extends AbstractStructBase
{
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * The ColourCode
     * @var string
     */
    public $ColourCode;
    /**
     * The SizeCode
     * @var string
     */
    public $SizeCode;
    /**
     * The Qty
     * @var float
     */
    public $Qty;
    /**
     * The InclSellPrice
     * @var float
     */
    public $InclSellPrice;
    /**
     * The IsGiftCard
     * @var bool
     */
    public $IsGiftCard;
    /**
     * Constructor method for TStockSaleType
     * @uses TStockSaleType::setItemCode()
     * @uses TStockSaleType::setColourCode()
     * @uses TStockSaleType::setSizeCode()
     * @uses TStockSaleType::setQty()
     * @uses TStockSaleType::setInclSellPrice()
     * @uses TStockSaleType::setIsGiftCard()
     * @param string $itemCode
     * @param string $colourCode
     * @param string $sizeCode
     * @param float $qty
     * @param float $inclSellPrice
     * @param bool $isGiftCard
     */
    public function __construct($itemCode = null, $colourCode = null, $sizeCode = null, $qty = null, $inclSellPrice = null, $isGiftCard = null)
    {
        $this
            ->setItemCode($itemCode)
            ->setColourCode($colourCode)
            ->setSizeCode($sizeCode)
            ->setQty($qty)
            ->setInclSellPrice($inclSellPrice)
            ->setIsGiftCard($isGiftCard);
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \tk_\StructType\TStockSaleType
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get ColourCode value
     * @return string|null
     */
    public function getColourCode()
    {
        return $this->ColourCode;
    }
    /**
     * Set ColourCode value
     * @param string $colourCode
     * @return \tk_\StructType\TStockSaleType
     */
    public function setColourCode($colourCode = null)
    {
        // validation for constraint: string
        if (!is_null($colourCode) && !is_string($colourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colourCode, true), gettype($colourCode)), __LINE__);
        }
        $this->ColourCode = $colourCode;
        return $this;
    }
    /**
     * Get SizeCode value
     * @return string|null
     */
    public function getSizeCode()
    {
        return $this->SizeCode;
    }
    /**
     * Set SizeCode value
     * @param string $sizeCode
     * @return \tk_\StructType\TStockSaleType
     */
    public function setSizeCode($sizeCode = null)
    {
        // validation for constraint: string
        if (!is_null($sizeCode) && !is_string($sizeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeCode, true), gettype($sizeCode)), __LINE__);
        }
        $this->SizeCode = $sizeCode;
        return $this;
    }
    /**
     * Get Qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \tk_\StructType\TStockSaleType
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get InclSellPrice value
     * @return float|null
     */
    public function getInclSellPrice()
    {
        return $this->InclSellPrice;
    }
    /**
     * Set InclSellPrice value
     * @param float $inclSellPrice
     * @return \tk_\StructType\TStockSaleType
     */
    public function setInclSellPrice($inclSellPrice = null)
    {
        // validation for constraint: float
        if (!is_null($inclSellPrice) && !(is_float($inclSellPrice) || is_numeric($inclSellPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inclSellPrice, true), gettype($inclSellPrice)), __LINE__);
        }
        $this->InclSellPrice = $inclSellPrice;
        return $this;
    }
    /**
     * Get IsGiftCard value
     * @return bool|null
     */
    public function getIsGiftCard()
    {
        return $this->IsGiftCard;
    }
    /**
     * Set IsGiftCard value
     * @param bool $isGiftCard
     * @return \tk_\StructType\TStockSaleType
     */
    public function setIsGiftCard($isGiftCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGiftCard) && !is_bool($isGiftCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGiftCard, true), gettype($isGiftCard)), __LINE__);
        }
        $this->IsGiftCard = $isGiftCard;
        return $this;
    }
}
