<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TGiftCardAuditType StructType
 * @subpackage Structs
 */
class TGiftCardAuditType extends AbstractStructBase
{
    /**
     * The CardNumber
     * @var string
     */
    public $CardNumber;
    /**
     * The Balance
     * @var float
     */
    public $Balance;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - arrayType: ns1:TGiftCardAuditDocument[]
     * - base: soapenc:Array
     * - ref: soapenc:arrayType
     * @var \tk_\StructType\TGiftCardAuditDocument[]
     */
    public $Documents;
    /**
     * Constructor method for TGiftCardAuditType
     * @uses TGiftCardAuditType::setCardNumber()
     * @uses TGiftCardAuditType::setBalance()
     * @uses TGiftCardAuditType::setStatus()
     * @uses TGiftCardAuditType::setDocuments()
     * @param string $cardNumber
     * @param float $balance
     * @param string $status
     * @param \tk_\StructType\TGiftCardAuditDocument[] $documents
     */
    public function __construct($cardNumber = null, $balance = null, $status = null, array $documents = array())
    {
        $this
            ->setCardNumber($cardNumber)
            ->setBalance($balance)
            ->setStatus($status)
            ->setDocuments($documents);
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \tk_\StructType\TGiftCardAuditType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \tk_\StructType\TGiftCardAuditType
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \tk_\StructType\TGiftCardAuditType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Documents value
     * @return \tk_\StructType\TGiftCardAuditDocument[]|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * This method is responsible for validating the values passed to the setDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsForArrayConstraintsFromSetDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tGiftCardAuditTypeDocumentsItem) {
            // validation for constraint: itemType
            if (!$tGiftCardAuditTypeDocumentsItem instanceof \tk_\StructType\TGiftCardAuditDocument) {
                $invalidValues[] = is_object($tGiftCardAuditTypeDocumentsItem) ? get_class($tGiftCardAuditTypeDocumentsItem) : sprintf('%s(%s)', gettype($tGiftCardAuditTypeDocumentsItem), var_export($tGiftCardAuditTypeDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Documents property can only contain items of type \tk_\StructType\TGiftCardAuditDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Documents value
     * @throws \InvalidArgumentException
     * @param \tk_\StructType\TGiftCardAuditDocument[] $documents
     * @return \tk_\StructType\TGiftCardAuditType
     */
    public function setDocuments(array $documents = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsArrayErrorMessage = self::validateDocumentsForArrayConstraintsFromSetDocuments($documents))) {
            throw new \InvalidArgumentException($documentsArrayErrorMessage, __LINE__);
        }
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Add item to Documents value
     * @throws \InvalidArgumentException
     * @param \tk_\StructType\TGiftCardAuditDocument $item
     * @return \tk_\StructType\TGiftCardAuditType
     */
    public function addToDocuments(\tk_\StructType\TGiftCardAuditDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \tk_\StructType\TGiftCardAuditDocument) {
            throw new \InvalidArgumentException(sprintf('The Documents property can only contain items of type \tk_\StructType\TGiftCardAuditDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Documents[] = $item;
        return $this;
    }
}
