<?php

namespace tk_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gift ServiceType
 * @subpackage Services
 */
class Gift extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GiftCardPurchase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \tk_\StructType\TGiftCardType|bool
     */
    public function GiftCardPurchase()
    {
        try {
            $this->setResult($this->getSoapClient()->GiftCardPurchase());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GiftCardCancelPurchase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $cardNumber
     * @return string|bool
     */
    public function GiftCardCancelPurchase($cardNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->GiftCardCancelPurchase($cardNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GiftCardsAvailable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \tk_\StructType\TGiftCardType[]|bool
     */
    public function GiftCardsAvailable()
    {
        try {
            $this->setResult($this->getSoapClient()->GiftCardsAvailable());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GiftCardBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $cardNumber
     * @return \tk_\StructType\TGiftCardType|bool
     */
    public function GiftCardBalance($cardNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->GiftCardBalance($cardNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GiftCardAudit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $cardNumber
     * @return \tk_\StructType\TGiftCardAuditType|bool
     */
    public function GiftCardAudit($cardNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->GiftCardAudit($cardNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\tk_\StructType\TGiftCardAuditType|\tk_\StructType\TGiftCardType|\tk_\StructType\TGiftCardType[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
