<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Currency ServiceType
 * @subpackage Services
 */
class Currency extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CurrencyName
     * Meta information extracted from the WSDL
     * - documentation: Returns the name of the currency (if found)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CurrencyName $parameters
     * @return \StructType\CurrencyNameResponse|bool
     */
    public function CurrencyName(\StructType\CurrencyName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CurrencyName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CurrencyNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
