<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tCountryCodeAndName StructType
 * @subpackage Structs
 */
class TCountryCodeAndName extends AbstractStructBase
{
    /**
     * The sISOCode
     * @var string
     */
    public $sISOCode;
    /**
     * The sName
     * @var string
     */
    public $sName;
    /**
     * Constructor method for tCountryCodeAndName
     * @uses TCountryCodeAndName::setSISOCode()
     * @uses TCountryCodeAndName::setSName()
     * @param string $sISOCode
     * @param string $sName
     */
    public function __construct($sISOCode = null, $sName = null)
    {
        $this
            ->setSISOCode($sISOCode)
            ->setSName($sName);
    }
    /**
     * Get sISOCode value
     * @return string|null
     */
    public function getSISOCode()
    {
        return $this->sISOCode;
    }
    /**
     * Set sISOCode value
     * @param string $sISOCode
     * @return \StructType\TCountryCodeAndName
     */
    public function setSISOCode($sISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($sISOCode) && !is_string($sISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sISOCode, true), gettype($sISOCode)), __LINE__);
        }
        $this->sISOCode = $sISOCode;
        return $this;
    }
    /**
     * Get sName value
     * @return string|null
     */
    public function getSName()
    {
        return $this->sName;
    }
    /**
     * Set sName value
     * @param string $sName
     * @return \StructType\TCountryCodeAndName
     */
    public function setSName($sName = null)
    {
        // validation for constraint: string
        if (!is_null($sName) && !is_string($sName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sName, true), gettype($sName)), __LINE__);
        }
        $this->sName = $sName;
        return $this;
    }
}
