<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Countries ServiceType
 * @subpackage Services
 */
class Countries extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CountriesUsingCurrency
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of all countries that use the same currency code. Pass a ISO currency code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CountriesUsingCurrency $parameters
     * @return \StructType\CountriesUsingCurrencyResponse|bool
     */
    public function CountriesUsingCurrency(\StructType\CountriesUsingCurrency $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountriesUsingCurrency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CountriesUsingCurrencyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
