<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Subtract ServiceType
 * @subpackage Services
 */
class Subtract extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Subtract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Subtract $parameters
     * @return \StructType\SubtractResponse|bool
     */
    public function Subtract(\StructType\Subtract $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Subtract($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SubtractResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
