<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadImagesRequest StructType
 * Meta information extracted from the WSDL
 * - type: ns:UploadImagesRequest
 * @subpackage Structs
 */
class UploadImagesRequest extends AbstractStructBase
{
    /**
     * The WebAuthenticationDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data to be used in authentication of the sender's identity (and right to use FedEx web services).
     * - minOccurs: 1
     * @var \StructType\WebAuthenticationDetail
     */
    public $WebAuthenticationDetail;
    /**
     * The ClientDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data identifying the client submitting the transaction.
     * - minOccurs: 1
     * @var \StructType\ClientDetail
     */
    public $ClientDetail;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Identifies the version/level of a service operation expected by a caller (in each request) and performed by the callee (in each reply).
     * - minOccurs: 1
     * @var \StructType\VersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data for this customer transaction. The TransactionDetail from the request is echoed back to the caller in the corresponding reply.
     * - minOccurs: 0
     * @var \StructType\TransactionDetail
     */
    public $TransactionDetail;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UploadImageDetail[]
     */
    public $Images;
    /**
     * Constructor method for UploadImagesRequest
     * @uses UploadImagesRequest::setWebAuthenticationDetail()
     * @uses UploadImagesRequest::setClientDetail()
     * @uses UploadImagesRequest::setVersion()
     * @uses UploadImagesRequest::setTransactionDetail()
     * @uses UploadImagesRequest::setImages()
     * @param \StructType\WebAuthenticationDetail $webAuthenticationDetail
     * @param \StructType\ClientDetail $clientDetail
     * @param \StructType\VersionId $version
     * @param \StructType\TransactionDetail $transactionDetail
     * @param \StructType\UploadImageDetail[] $images
     */
    public function __construct(\StructType\WebAuthenticationDetail $webAuthenticationDetail = null, \StructType\ClientDetail $clientDetail = null, \StructType\VersionId $version = null, \StructType\TransactionDetail $transactionDetail = null, array $images = array())
    {
        $this
            ->setWebAuthenticationDetail($webAuthenticationDetail)
            ->setClientDetail($clientDetail)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setImages($images);
    }
    /**
     * Get WebAuthenticationDetail value
     * @return \StructType\WebAuthenticationDetail
     */
    public function getWebAuthenticationDetail()
    {
        return $this->WebAuthenticationDetail;
    }
    /**
     * Set WebAuthenticationDetail value
     * @param \StructType\WebAuthenticationDetail $webAuthenticationDetail
     * @return \StructType\UploadImagesRequest
     */
    public function setWebAuthenticationDetail(\StructType\WebAuthenticationDetail $webAuthenticationDetail = null)
    {
        $this->WebAuthenticationDetail = $webAuthenticationDetail;
        return $this;
    }
    /**
     * Get ClientDetail value
     * @return \StructType\ClientDetail
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \StructType\ClientDetail $clientDetail
     * @return \StructType\UploadImagesRequest
     */
    public function setClientDetail(\StructType\ClientDetail $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\VersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\VersionId $version
     * @return \StructType\UploadImagesRequest
     */
    public function setVersion(\StructType\VersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \StructType\TransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \StructType\TransactionDetail $transactionDetail
     * @return \StructType\UploadImagesRequest
     */
    public function setTransactionDetail(\StructType\TransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get Images value
     * @return \StructType\UploadImageDetail[]|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * This method is responsible for validating the values passed to the setImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImagesForArrayConstraintsFromSetImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uploadImagesRequestImagesItem) {
            // validation for constraint: itemType
            if (!$uploadImagesRequestImagesItem instanceof \StructType\UploadImageDetail) {
                $invalidValues[] = is_object($uploadImagesRequestImagesItem) ? get_class($uploadImagesRequestImagesItem) : sprintf('%s(%s)', gettype($uploadImagesRequestImagesItem), var_export($uploadImagesRequestImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Images property can only contain items of type \StructType\UploadImageDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Images value
     * @throws \InvalidArgumentException
     * @param \StructType\UploadImageDetail[] $images
     * @return \StructType\UploadImagesRequest
     */
    public function setImages(array $images = array())
    {
        // validation for constraint: array
        if ('' !== ($imagesArrayErrorMessage = self::validateImagesForArrayConstraintsFromSetImages($images))) {
            throw new \InvalidArgumentException($imagesArrayErrorMessage, __LINE__);
        }
        $this->Images = $images;
        return $this;
    }
    /**
     * Add item to Images value
     * @throws \InvalidArgumentException
     * @param \StructType\UploadImageDetail $item
     * @return \StructType\UploadImagesRequest
     */
    public function addToImages(\StructType\UploadImageDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UploadImageDetail) {
            throw new \InvalidArgumentException(sprintf('The Images property can only contain items of type \StructType\UploadImageDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Images[] = $item;
        return $this;
    }
}
