<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadImagesReply StructType
 * Meta information extracted from the WSDL
 * - type: ns:UploadImagesReply
 * @subpackage Structs
 */
class UploadImagesReply extends AbstractStructBase
{
    /**
     * The HighestSeverity
     * Meta information extracted from the WSDL
     * - documentation: Identifies the highest severity encountered when executing the request; in order from high to low: FAILURE, ERROR, WARNING, NOTE, SUCCESS.
     * - minOccurs: 1
     * @var string
     */
    public $HighestSeverity;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - documentation: The descriptive data detailing the status of a sumbitted transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Notification[]
     */
    public $Notifications;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Identifies the version/level of a service operation expected by a caller (in each request) and performed by the callee (in each reply).
     * - minOccurs: 1
     * @var \StructType\VersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data that governs data payload language/translations. The TransactionDetail from the request is echoed back to the caller in the corresponding reply.
     * - minOccurs: 0
     * @var \StructType\TransactionDetail
     */
    public $TransactionDetail;
    /**
     * The ImageStatuses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImageUploadStatusDetail[]
     */
    public $ImageStatuses;
    /**
     * Constructor method for UploadImagesReply
     * @uses UploadImagesReply::setHighestSeverity()
     * @uses UploadImagesReply::setNotifications()
     * @uses UploadImagesReply::setVersion()
     * @uses UploadImagesReply::setTransactionDetail()
     * @uses UploadImagesReply::setImageStatuses()
     * @param string $highestSeverity
     * @param \StructType\Notification[] $notifications
     * @param \StructType\VersionId $version
     * @param \StructType\TransactionDetail $transactionDetail
     * @param \StructType\ImageUploadStatusDetail[] $imageStatuses
     */
    public function __construct($highestSeverity = null, array $notifications = array(), \StructType\VersionId $version = null, \StructType\TransactionDetail $transactionDetail = null, array $imageStatuses = array())
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setNotifications($notifications)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setImageStatuses($imageStatuses);
    }
    /**
     * Get HighestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->HighestSeverity;
    }
    /**
     * Set HighestSeverity value
     * @uses \EnumType\NotificationSeverityType::valueIsValid()
     * @uses \EnumType\NotificationSeverityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \StructType\UploadImagesReply
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotificationSeverityType::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NotificationSeverityType', is_array($highestSeverity) ? implode(', ', $highestSeverity) : var_export($highestSeverity, true), implode(', ', \EnumType\NotificationSeverityType::getValidValues())), __LINE__);
        }
        $this->HighestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \StructType\Notification[]
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * This method is responsible for validating the values passed to the setNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationsForArrayConstraintsFromSetNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uploadImagesReplyNotificationsItem) {
            // validation for constraint: itemType
            if (!$uploadImagesReplyNotificationsItem instanceof \StructType\Notification) {
                $invalidValues[] = is_object($uploadImagesReplyNotificationsItem) ? get_class($uploadImagesReplyNotificationsItem) : sprintf('%s(%s)', gettype($uploadImagesReplyNotificationsItem), var_export($uploadImagesReplyNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notifications property can only contain items of type \StructType\Notification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notifications value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification[] $notifications
     * @return \StructType\UploadImagesReply
     */
    public function setNotifications(array $notifications = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationsArrayErrorMessage = self::validateNotificationsForArrayConstraintsFromSetNotifications($notifications))) {
            throw new \InvalidArgumentException($notificationsArrayErrorMessage, __LINE__);
        }
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Add item to Notifications value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification $item
     * @return \StructType\UploadImagesReply
     */
    public function addToNotifications(\StructType\Notification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Notification) {
            throw new \InvalidArgumentException(sprintf('The Notifications property can only contain items of type \StructType\Notification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notifications[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\VersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\VersionId $version
     * @return \StructType\UploadImagesReply
     */
    public function setVersion(\StructType\VersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \StructType\TransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \StructType\TransactionDetail $transactionDetail
     * @return \StructType\UploadImagesReply
     */
    public function setTransactionDetail(\StructType\TransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get ImageStatuses value
     * @return \StructType\ImageUploadStatusDetail[]|null
     */
    public function getImageStatuses()
    {
        return $this->ImageStatuses;
    }
    /**
     * This method is responsible for validating the values passed to the setImageStatuses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageStatuses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageStatusesForArrayConstraintsFromSetImageStatuses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uploadImagesReplyImageStatusesItem) {
            // validation for constraint: itemType
            if (!$uploadImagesReplyImageStatusesItem instanceof \StructType\ImageUploadStatusDetail) {
                $invalidValues[] = is_object($uploadImagesReplyImageStatusesItem) ? get_class($uploadImagesReplyImageStatusesItem) : sprintf('%s(%s)', gettype($uploadImagesReplyImageStatusesItem), var_export($uploadImagesReplyImageStatusesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageStatuses property can only contain items of type \StructType\ImageUploadStatusDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageStatuses value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageUploadStatusDetail[] $imageStatuses
     * @return \StructType\UploadImagesReply
     */
    public function setImageStatuses(array $imageStatuses = array())
    {
        // validation for constraint: array
        if ('' !== ($imageStatusesArrayErrorMessage = self::validateImageStatusesForArrayConstraintsFromSetImageStatuses($imageStatuses))) {
            throw new \InvalidArgumentException($imageStatusesArrayErrorMessage, __LINE__);
        }
        $this->ImageStatuses = $imageStatuses;
        return $this;
    }
    /**
     * Add item to ImageStatuses value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageUploadStatusDetail $item
     * @return \StructType\UploadImagesReply
     */
    public function addToImageStatuses(\StructType\ImageUploadStatusDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageUploadStatusDetail) {
            throw new \InvalidArgumentException(sprintf('The ImageStatuses property can only contain items of type \StructType\ImageUploadStatusDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageStatuses[] = $item;
        return $this;
    }
}
