<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadImageDetail StructType
 * @subpackage Structs
 */
class UploadImageDetail extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Image;
    /**
     * Constructor method for UploadImageDetail
     * @uses UploadImageDetail::setId()
     * @uses UploadImageDetail::setImage()
     * @param string $id
     * @param string $image
     */
    public function __construct($id = null, $image = null)
    {
        $this
            ->setId($id)
            ->setImage($image);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @uses \EnumType\ImageId::valueIsValid()
     * @uses \EnumType\ImageId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $id
     * @return \StructType\UploadImageDetail
     */
    public function setId($id = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImageId::valueIsValid($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImageId', is_array($id) ? implode(', ', $id) : var_export($id, true), implode(', ', \EnumType\ImageId::getValidValues())), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param string $image
     * @return \StructType\UploadImageDetail
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
}
