<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageUploadStatusDetail StructType
 * @subpackage Structs
 */
class ImageUploadStatusDetail extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusInfo;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for ImageUploadStatusDetail
     * @uses ImageUploadStatusDetail::setId()
     * @uses ImageUploadStatusDetail::setStatus()
     * @uses ImageUploadStatusDetail::setStatusInfo()
     * @uses ImageUploadStatusDetail::setMessage()
     * @param string $id
     * @param string $status
     * @param string $statusInfo
     * @param string $message
     */
    public function __construct($id = null, $status = null, $statusInfo = null, $message = null)
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setStatusInfo($statusInfo)
            ->setMessage($message);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @uses \EnumType\ImageId::valueIsValid()
     * @uses \EnumType\ImageId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $id
     * @return \StructType\ImageUploadStatusDetail
     */
    public function setId($id = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImageId::valueIsValid($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImageId', is_array($id) ? implode(', ', $id) : var_export($id, true), implode(', ', \EnumType\ImageId::getValidValues())), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\UploadImageStatusType::valueIsValid()
     * @uses \EnumType\UploadImageStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ImageUploadStatusDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UploadImageStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UploadImageStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\UploadImageStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusInfo value
     * @return string|null
     */
    public function getStatusInfo()
    {
        return $this->StatusInfo;
    }
    /**
     * Set StatusInfo value
     * @uses \EnumType\UploadImageStatusInfoType::valueIsValid()
     * @uses \EnumType\UploadImageStatusInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusInfo
     * @return \StructType\ImageUploadStatusDetail
     */
    public function setStatusInfo($statusInfo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UploadImageStatusInfoType::valueIsValid($statusInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UploadImageStatusInfoType', is_array($statusInfo) ? implode(', ', $statusInfo) : var_export($statusInfo, true), implode(', ', \EnumType\UploadImageStatusInfoType::getValidValues())), __LINE__);
        }
        $this->StatusInfo = $statusInfo;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\ImageUploadStatusDetail
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
