<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named uploadDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadDocumentsRequest $uploadDocumentsRequest
     * @return \StructType\UploadDocumentsReply|bool
     */
    public function uploadDocuments(\StructType\UploadDocumentsRequest $uploadDocumentsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->uploadDocuments($uploadDocumentsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named uploadImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadImagesRequest $uploadImagesRequest
     * @return \StructType\UploadImagesReply|bool
     */
    public function uploadImages(\StructType\UploadImagesRequest $uploadImagesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->uploadImages($uploadImagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UploadDocumentsReply|\StructType\UploadImagesReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
