<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocumentStatusDetail StructType
 * @subpackage Structs
 */
class UploadDocumentStatusDetail extends AbstractStructBase
{
    /**
     * The LineNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LineNumber;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference;
    /**
     * The DocumentProducer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentProducer;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusInfo
     * Meta information extracted from the WSDL
     * - documentation: Distinct value for reason status was assigned.
     * - minOccurs: 0
     * @var string
     */
    public $StatusInfo;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Human-readable explanation of document status.
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The DocumentIdProducer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentIdProducer;
    /**
     * Constructor method for UploadDocumentStatusDetail
     * @uses UploadDocumentStatusDetail::setLineNumber()
     * @uses UploadDocumentStatusDetail::setCustomerReference()
     * @uses UploadDocumentStatusDetail::setDocumentProducer()
     * @uses UploadDocumentStatusDetail::setDocumentType()
     * @uses UploadDocumentStatusDetail::setFileName()
     * @uses UploadDocumentStatusDetail::setStatus()
     * @uses UploadDocumentStatusDetail::setStatusInfo()
     * @uses UploadDocumentStatusDetail::setMessage()
     * @uses UploadDocumentStatusDetail::setDocumentId()
     * @uses UploadDocumentStatusDetail::setDocumentIdProducer()
     * @param int $lineNumber
     * @param string $customerReference
     * @param string $documentProducer
     * @param string $documentType
     * @param string $fileName
     * @param string $status
     * @param string $statusInfo
     * @param string $message
     * @param string $documentId
     * @param string $documentIdProducer
     */
    public function __construct($lineNumber = null, $customerReference = null, $documentProducer = null, $documentType = null, $fileName = null, $status = null, $statusInfo = null, $message = null, $documentId = null, $documentIdProducer = null)
    {
        $this
            ->setLineNumber($lineNumber)
            ->setCustomerReference($customerReference)
            ->setDocumentProducer($documentProducer)
            ->setDocumentType($documentType)
            ->setFileName($fileName)
            ->setStatus($status)
            ->setStatusInfo($statusInfo)
            ->setMessage($message)
            ->setDocumentId($documentId)
            ->setDocumentIdProducer($documentIdProducer);
    }
    /**
     * Get LineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param string $customerReference
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Get DocumentProducer value
     * @return string|null
     */
    public function getDocumentProducer()
    {
        return $this->DocumentProducer;
    }
    /**
     * Set DocumentProducer value
     * @uses \EnumType\UploadDocumentProducerType::valueIsValid()
     * @uses \EnumType\UploadDocumentProducerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentProducer
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setDocumentProducer($documentProducer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UploadDocumentProducerType::valueIsValid($documentProducer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UploadDocumentProducerType', is_array($documentProducer) ? implode(', ', $documentProducer) : var_export($documentProducer, true), implode(', ', \EnumType\UploadDocumentProducerType::getValidValues())), __LINE__);
        }
        $this->DocumentProducer = $documentProducer;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @uses \EnumType\UploadDocumentType::valueIsValid()
     * @uses \EnumType\UploadDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UploadDocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UploadDocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \EnumType\UploadDocumentType::getValidValues())), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\UploadDocumentStatusType::valueIsValid()
     * @uses \EnumType\UploadDocumentStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UploadDocumentStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UploadDocumentStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\UploadDocumentStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusInfo value
     * @return string|null
     */
    public function getStatusInfo()
    {
        return $this->StatusInfo;
    }
    /**
     * Set StatusInfo value
     * @uses \EnumType\UploadDocumentStatusInfoType::valueIsValid()
     * @uses \EnumType\UploadDocumentStatusInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusInfo
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setStatusInfo($statusInfo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UploadDocumentStatusInfoType::valueIsValid($statusInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UploadDocumentStatusInfoType', is_array($statusInfo) ? implode(', ', $statusInfo) : var_export($statusInfo, true), implode(', ', \EnumType\UploadDocumentStatusInfoType::getValidValues())), __LINE__);
        }
        $this->StatusInfo = $statusInfo;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get DocumentIdProducer value
     * @return string|null
     */
    public function getDocumentIdProducer()
    {
        return $this->DocumentIdProducer;
    }
    /**
     * Set DocumentIdProducer value
     * @uses \EnumType\UploadDocumentIdProducer::valueIsValid()
     * @uses \EnumType\UploadDocumentIdProducer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentIdProducer
     * @return \StructType\UploadDocumentStatusDetail
     */
    public function setDocumentIdProducer($documentIdProducer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UploadDocumentIdProducer::valueIsValid($documentIdProducer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UploadDocumentIdProducer', is_array($documentIdProducer) ? implode(', ', $documentIdProducer) : var_export($documentIdProducer, true), implode(', ', \EnumType\UploadDocumentIdProducer::getValidValues())), __LINE__);
        }
        $this->DocumentIdProducer = $documentIdProducer;
        return $this;
    }
}
