<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Descriptive data for the client submitting a transaction.
 * @subpackage Structs
 */
class ClientDetail extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - documentation: The FedEx account number associated with this transaction.
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The MeterNumber
     * Meta information extracted from the WSDL
     * - documentation: This number is assigned by FedEx and identifies the unique device from which the request is originating
     * - minOccurs: 1
     * @var string
     */
    public $MeterNumber;
    /**
     * The IntegratorId
     * Meta information extracted from the WSDL
     * - documentation: Only used in transactions which require identification of the FedEx Office integrator.
     * - minOccurs: 0
     * @var string
     */
    public $IntegratorId;
    /**
     * The Localization
     * Meta information extracted from the WSDL
     * - documentation: The language to be used for human-readable Notification.localizedMessages in responses to the request containing this ClientDetail object. Different requests from the same client may contain different Localization data. (Contrast
     * with TransactionDetail.localization, which governs data payload language/translation.)
     * - minOccurs: 0
     * @var \StructType\Localization
     */
    public $Localization;
    /**
     * Constructor method for ClientDetail
     * @uses ClientDetail::setAccountNumber()
     * @uses ClientDetail::setMeterNumber()
     * @uses ClientDetail::setIntegratorId()
     * @uses ClientDetail::setLocalization()
     * @param string $accountNumber
     * @param string $meterNumber
     * @param string $integratorId
     * @param \StructType\Localization $localization
     */
    public function __construct($accountNumber = null, $meterNumber = null, $integratorId = null, \StructType\Localization $localization = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setMeterNumber($meterNumber)
            ->setIntegratorId($integratorId)
            ->setLocalization($localization);
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\ClientDetail
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get MeterNumber value
     * @return string
     */
    public function getMeterNumber()
    {
        return $this->MeterNumber;
    }
    /**
     * Set MeterNumber value
     * @param string $meterNumber
     * @return \StructType\ClientDetail
     */
    public function setMeterNumber($meterNumber = null)
    {
        // validation for constraint: string
        if (!is_null($meterNumber) && !is_string($meterNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meterNumber, true), gettype($meterNumber)), __LINE__);
        }
        $this->MeterNumber = $meterNumber;
        return $this;
    }
    /**
     * Get IntegratorId value
     * @return string|null
     */
    public function getIntegratorId()
    {
        return $this->IntegratorId;
    }
    /**
     * Set IntegratorId value
     * @param string $integratorId
     * @return \StructType\ClientDetail
     */
    public function setIntegratorId($integratorId = null)
    {
        // validation for constraint: string
        if (!is_null($integratorId) && !is_string($integratorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integratorId, true), gettype($integratorId)), __LINE__);
        }
        $this->IntegratorId = $integratorId;
        return $this;
    }
    /**
     * Get Localization value
     * @return \StructType\Localization|null
     */
    public function getLocalization()
    {
        return $this->Localization;
    }
    /**
     * Set Localization value
     * @param \StructType\Localization $localization
     * @return \StructType\ClientDetail
     */
    public function setLocalization(\StructType\Localization $localization = null)
    {
        $this->Localization = $localization;
        return $this;
    }
}
