<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebAuthenticationCredential StructType
 * Meta information extracted from the WSDL
 * - documentation: Two part authentication string used for the sender's identity
 * @subpackage Structs
 */
class WebAuthenticationCredential extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - documentation: Identifying part of authentication credential. This value is provided by FedEx after registration
     * - minOccurs: 1
     * @var string
     */
    public $Key;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - documentation: Secret part of authentication key. This value is provided by FedEx after registration.
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * Constructor method for WebAuthenticationCredential
     * @uses WebAuthenticationCredential::setKey()
     * @uses WebAuthenticationCredential::setPassword()
     * @param string $key
     * @param string $password
     */
    public function __construct($key = null, $password = null)
    {
        $this
            ->setKey($key)
            ->setPassword($password);
    }
    /**
     * Get Key value
     * @return string
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \StructType\WebAuthenticationCredential
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\WebAuthenticationCredential
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
