<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocumentsRequest StructType
 * Meta information extracted from the WSDL
 * - type: ns:UploadDocumentsRequest
 * @subpackage Structs
 */
class UploadDocumentsRequest extends AbstractStructBase
{
    /**
     * The WebAuthenticationDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data to be used in authentication of the sender's identity (and right to use FedEx web services).
     * - minOccurs: 1
     * @var \StructType\WebAuthenticationDetail
     */
    public $WebAuthenticationDetail;
    /**
     * The ClientDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data identifying the client submitting the transaction.
     * - minOccurs: 1
     * @var \StructType\ClientDetail
     */
    public $ClientDetail;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Identifies the version/level of a service operation expected by a caller (in each request) and performed by the callee (in each reply).
     * - minOccurs: 1
     * @var \StructType\VersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data for this customer transaction. The TransactionDetail from the request is echoed back to the caller in the corresponding reply.
     * - minOccurs: 0
     * @var \StructType\TransactionDetail
     */
    public $TransactionDetail;
    /**
     * The OriginCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginCountryCode;
    /**
     * The DestinationCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCountryCode;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - documentation: Specifies the intent or the usage of the documents being uploaded. This provides details about how the documents are relevant to the current transaction.
     * - minOccurs: 0
     * @var string
     */
    public $Usage;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UploadDocumentDetail[]
     */
    public $Documents;
    /**
     * Constructor method for UploadDocumentsRequest
     * @uses UploadDocumentsRequest::setWebAuthenticationDetail()
     * @uses UploadDocumentsRequest::setClientDetail()
     * @uses UploadDocumentsRequest::setVersion()
     * @uses UploadDocumentsRequest::setTransactionDetail()
     * @uses UploadDocumentsRequest::setOriginCountryCode()
     * @uses UploadDocumentsRequest::setDestinationCountryCode()
     * @uses UploadDocumentsRequest::setUsage()
     * @uses UploadDocumentsRequest::setDocuments()
     * @param \StructType\WebAuthenticationDetail $webAuthenticationDetail
     * @param \StructType\ClientDetail $clientDetail
     * @param \StructType\VersionId $version
     * @param \StructType\TransactionDetail $transactionDetail
     * @param string $originCountryCode
     * @param string $destinationCountryCode
     * @param string $usage
     * @param \StructType\UploadDocumentDetail[] $documents
     */
    public function __construct(\StructType\WebAuthenticationDetail $webAuthenticationDetail = null, \StructType\ClientDetail $clientDetail = null, \StructType\VersionId $version = null, \StructType\TransactionDetail $transactionDetail = null, $originCountryCode = null, $destinationCountryCode = null, $usage = null, array $documents = array())
    {
        $this
            ->setWebAuthenticationDetail($webAuthenticationDetail)
            ->setClientDetail($clientDetail)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setOriginCountryCode($originCountryCode)
            ->setDestinationCountryCode($destinationCountryCode)
            ->setUsage($usage)
            ->setDocuments($documents);
    }
    /**
     * Get WebAuthenticationDetail value
     * @return \StructType\WebAuthenticationDetail
     */
    public function getWebAuthenticationDetail()
    {
        return $this->WebAuthenticationDetail;
    }
    /**
     * Set WebAuthenticationDetail value
     * @param \StructType\WebAuthenticationDetail $webAuthenticationDetail
     * @return \StructType\UploadDocumentsRequest
     */
    public function setWebAuthenticationDetail(\StructType\WebAuthenticationDetail $webAuthenticationDetail = null)
    {
        $this->WebAuthenticationDetail = $webAuthenticationDetail;
        return $this;
    }
    /**
     * Get ClientDetail value
     * @return \StructType\ClientDetail
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \StructType\ClientDetail $clientDetail
     * @return \StructType\UploadDocumentsRequest
     */
    public function setClientDetail(\StructType\ClientDetail $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\VersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\VersionId $version
     * @return \StructType\UploadDocumentsRequest
     */
    public function setVersion(\StructType\VersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \StructType\TransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \StructType\TransactionDetail $transactionDetail
     * @return \StructType\UploadDocumentsRequest
     */
    public function setTransactionDetail(\StructType\TransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get OriginCountryCode value
     * @return string|null
     */
    public function getOriginCountryCode()
    {
        return $this->OriginCountryCode;
    }
    /**
     * Set OriginCountryCode value
     * @param string $originCountryCode
     * @return \StructType\UploadDocumentsRequest
     */
    public function setOriginCountryCode($originCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCountryCode) && !is_string($originCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCountryCode, true), gettype($originCountryCode)), __LINE__);
        }
        $this->OriginCountryCode = $originCountryCode;
        return $this;
    }
    /**
     * Get DestinationCountryCode value
     * @return string|null
     */
    public function getDestinationCountryCode()
    {
        return $this->DestinationCountryCode;
    }
    /**
     * Set DestinationCountryCode value
     * @param string $destinationCountryCode
     * @return \StructType\UploadDocumentsRequest
     */
    public function setDestinationCountryCode($destinationCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCountryCode) && !is_string($destinationCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCountryCode, true), gettype($destinationCountryCode)), __LINE__);
        }
        $this->DestinationCountryCode = $destinationCountryCode;
        return $this;
    }
    /**
     * Get Usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * Set Usage value
     * @uses \EnumType\DocumentUsageType::valueIsValid()
     * @uses \EnumType\DocumentUsageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \StructType\UploadDocumentsRequest
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentUsageType::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DocumentUsageType', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \EnumType\DocumentUsageType::getValidValues())), __LINE__);
        }
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Get Documents value
     * @return \StructType\UploadDocumentDetail[]|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * This method is responsible for validating the values passed to the setDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsForArrayConstraintsFromSetDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uploadDocumentsRequestDocumentsItem) {
            // validation for constraint: itemType
            if (!$uploadDocumentsRequestDocumentsItem instanceof \StructType\UploadDocumentDetail) {
                $invalidValues[] = is_object($uploadDocumentsRequestDocumentsItem) ? get_class($uploadDocumentsRequestDocumentsItem) : sprintf('%s(%s)', gettype($uploadDocumentsRequestDocumentsItem), var_export($uploadDocumentsRequestDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Documents property can only contain items of type \StructType\UploadDocumentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Documents value
     * @throws \InvalidArgumentException
     * @param \StructType\UploadDocumentDetail[] $documents
     * @return \StructType\UploadDocumentsRequest
     */
    public function setDocuments(array $documents = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsArrayErrorMessage = self::validateDocumentsForArrayConstraintsFromSetDocuments($documents))) {
            throw new \InvalidArgumentException($documentsArrayErrorMessage, __LINE__);
        }
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Add item to Documents value
     * @throws \InvalidArgumentException
     * @param \StructType\UploadDocumentDetail $item
     * @return \StructType\UploadDocumentsRequest
     */
    public function addToDocuments(\StructType\UploadDocumentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UploadDocumentDetail) {
            throw new \InvalidArgumentException(sprintf('The Documents property can only contain items of type \StructType\UploadDocumentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Documents[] = $item;
        return $this;
    }
}
