<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocumentsReply StructType
 * Meta information extracted from the WSDL
 * - type: ns:UploadDocumentsReply
 * @subpackage Structs
 */
class UploadDocumentsReply extends AbstractStructBase
{
    /**
     * The HighestSeverity
     * Meta information extracted from the WSDL
     * - documentation: This indicates the highest level of severity of all the notifications returned in this reply
     * - minOccurs: 1
     * @var string
     */
    public $HighestSeverity;
    /**
     * The Notifications
     * Meta information extracted from the WSDL
     * - documentation: The descriptive data regarding the results of the submitted transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Notification[]
     */
    public $Notifications;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Identifies the version/level of a service operation expected by a caller (in each request) and performed by the callee (in each reply).
     * - minOccurs: 1
     * @var \StructType\VersionId
     */
    public $Version;
    /**
     * The TransactionDetail
     * Meta information extracted from the WSDL
     * - documentation: Descriptive data for this customer transaction. The TransactionDetail from the request is echoed back to the caller in the corresponding reply.
     * - minOccurs: 0
     * @var \StructType\TransactionDetail
     */
    public $TransactionDetail;
    /**
     * The DocumentStatuses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UploadDocumentStatusDetail[]
     */
    public $DocumentStatuses;
    /**
     * Constructor method for UploadDocumentsReply
     * @uses UploadDocumentsReply::setHighestSeverity()
     * @uses UploadDocumentsReply::setNotifications()
     * @uses UploadDocumentsReply::setVersion()
     * @uses UploadDocumentsReply::setTransactionDetail()
     * @uses UploadDocumentsReply::setDocumentStatuses()
     * @param string $highestSeverity
     * @param \StructType\Notification[] $notifications
     * @param \StructType\VersionId $version
     * @param \StructType\TransactionDetail $transactionDetail
     * @param \StructType\UploadDocumentStatusDetail[] $documentStatuses
     */
    public function __construct($highestSeverity = null, array $notifications = array(), \StructType\VersionId $version = null, \StructType\TransactionDetail $transactionDetail = null, array $documentStatuses = array())
    {
        $this
            ->setHighestSeverity($highestSeverity)
            ->setNotifications($notifications)
            ->setVersion($version)
            ->setTransactionDetail($transactionDetail)
            ->setDocumentStatuses($documentStatuses);
    }
    /**
     * Get HighestSeverity value
     * @return string
     */
    public function getHighestSeverity()
    {
        return $this->HighestSeverity;
    }
    /**
     * Set HighestSeverity value
     * @uses \EnumType\NotificationSeverityType::valueIsValid()
     * @uses \EnumType\NotificationSeverityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $highestSeverity
     * @return \StructType\UploadDocumentsReply
     */
    public function setHighestSeverity($highestSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotificationSeverityType::valueIsValid($highestSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NotificationSeverityType', is_array($highestSeverity) ? implode(', ', $highestSeverity) : var_export($highestSeverity, true), implode(', ', \EnumType\NotificationSeverityType::getValidValues())), __LINE__);
        }
        $this->HighestSeverity = $highestSeverity;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \StructType\Notification[]
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * This method is responsible for validating the values passed to the setNotifications method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotifications method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationsForArrayConstraintsFromSetNotifications(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uploadDocumentsReplyNotificationsItem) {
            // validation for constraint: itemType
            if (!$uploadDocumentsReplyNotificationsItem instanceof \StructType\Notification) {
                $invalidValues[] = is_object($uploadDocumentsReplyNotificationsItem) ? get_class($uploadDocumentsReplyNotificationsItem) : sprintf('%s(%s)', gettype($uploadDocumentsReplyNotificationsItem), var_export($uploadDocumentsReplyNotificationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notifications property can only contain items of type \StructType\Notification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notifications value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification[] $notifications
     * @return \StructType\UploadDocumentsReply
     */
    public function setNotifications(array $notifications = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationsArrayErrorMessage = self::validateNotificationsForArrayConstraintsFromSetNotifications($notifications))) {
            throw new \InvalidArgumentException($notificationsArrayErrorMessage, __LINE__);
        }
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Add item to Notifications value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification $item
     * @return \StructType\UploadDocumentsReply
     */
    public function addToNotifications(\StructType\Notification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Notification) {
            throw new \InvalidArgumentException(sprintf('The Notifications property can only contain items of type \StructType\Notification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notifications[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\VersionId
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\VersionId $version
     * @return \StructType\UploadDocumentsReply
     */
    public function setVersion(\StructType\VersionId $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionDetail value
     * @return \StructType\TransactionDetail|null
     */
    public function getTransactionDetail()
    {
        return $this->TransactionDetail;
    }
    /**
     * Set TransactionDetail value
     * @param \StructType\TransactionDetail $transactionDetail
     * @return \StructType\UploadDocumentsReply
     */
    public function setTransactionDetail(\StructType\TransactionDetail $transactionDetail = null)
    {
        $this->TransactionDetail = $transactionDetail;
        return $this;
    }
    /**
     * Get DocumentStatuses value
     * @return \StructType\UploadDocumentStatusDetail[]|null
     */
    public function getDocumentStatuses()
    {
        return $this->DocumentStatuses;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentStatuses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentStatuses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentStatusesForArrayConstraintsFromSetDocumentStatuses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uploadDocumentsReplyDocumentStatusesItem) {
            // validation for constraint: itemType
            if (!$uploadDocumentsReplyDocumentStatusesItem instanceof \StructType\UploadDocumentStatusDetail) {
                $invalidValues[] = is_object($uploadDocumentsReplyDocumentStatusesItem) ? get_class($uploadDocumentsReplyDocumentStatusesItem) : sprintf('%s(%s)', gettype($uploadDocumentsReplyDocumentStatusesItem), var_export($uploadDocumentsReplyDocumentStatusesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentStatuses property can only contain items of type \StructType\UploadDocumentStatusDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentStatuses value
     * @throws \InvalidArgumentException
     * @param \StructType\UploadDocumentStatusDetail[] $documentStatuses
     * @return \StructType\UploadDocumentsReply
     */
    public function setDocumentStatuses(array $documentStatuses = array())
    {
        // validation for constraint: array
        if ('' !== ($documentStatusesArrayErrorMessage = self::validateDocumentStatusesForArrayConstraintsFromSetDocumentStatuses($documentStatuses))) {
            throw new \InvalidArgumentException($documentStatusesArrayErrorMessage, __LINE__);
        }
        $this->DocumentStatuses = $documentStatuses;
        return $this;
    }
    /**
     * Add item to DocumentStatuses value
     * @throws \InvalidArgumentException
     * @param \StructType\UploadDocumentStatusDetail $item
     * @return \StructType\UploadDocumentsReply
     */
    public function addToDocumentStatuses(\StructType\UploadDocumentStatusDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UploadDocumentStatusDetail) {
            throw new \InvalidArgumentException(sprintf('The DocumentStatuses property can only contain items of type \StructType\UploadDocumentStatusDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentStatuses[] = $item;
        return $this;
    }
}
