<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification StructType
 * Meta information extracted from the WSDL
 * - documentation: The descriptive data regarding the result of the submitted transaction.
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The Severity
     * Meta information extracted from the WSDL
     * - documentation: The severity of this notification. This can indicate success or failure or some other information about the request. The values that can be returned are SUCCESS - Your transaction succeeded with no other applicable information. NOTE
     * - Additional information that may be of interest to you about your transaction. WARNING - Additional information that you need to know about your transaction that you may need to take action on. ERROR - Information about an error that occurred while
     * processing your transaction. FAILURE - FedEx was unable to process your transaction at this time due to a system failure. Please try again later
     * - minOccurs: 0
     * @var string
     */
    public $Severity;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - documentation: Indicates the source of this notification. Combined with the Code it uniquely identifies this notification
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: A code that represents this notification. Combined with the Source it uniquely identifies this notification.
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Human-readable text that explains this notification.
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The LocalizedMessage
     * Meta information extracted from the WSDL
     * - documentation: The translated message. The language and locale specified in the ClientDetail. Localization are used to determine the representation. Currently only supported in a TrackReply.
     * - minOccurs: 0
     * @var string
     */
    public $LocalizedMessage;
    /**
     * The MessageParameters
     * Meta information extracted from the WSDL
     * - documentation: A collection of name/value pairs that provide specific data to help the client determine the nature of an error (or warning, etc.) witout having to parse the message string.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NotificationParameter[]
     */
    public $MessageParameters;
    /**
     * Constructor method for Notification
     * @uses Notification::setSeverity()
     * @uses Notification::setSource()
     * @uses Notification::setCode()
     * @uses Notification::setMessage()
     * @uses Notification::setLocalizedMessage()
     * @uses Notification::setMessageParameters()
     * @param string $severity
     * @param string $source
     * @param string $code
     * @param string $message
     * @param string $localizedMessage
     * @param \StructType\NotificationParameter[] $messageParameters
     */
    public function __construct($severity = null, $source = null, $code = null, $message = null, $localizedMessage = null, array $messageParameters = array())
    {
        $this
            ->setSeverity($severity)
            ->setSource($source)
            ->setCode($code)
            ->setMessage($message)
            ->setLocalizedMessage($localizedMessage)
            ->setMessageParameters($messageParameters);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @uses \EnumType\NotificationSeverityType::valueIsValid()
     * @uses \EnumType\NotificationSeverityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \StructType\Notification
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotificationSeverityType::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NotificationSeverityType', is_array($severity) ? implode(', ', $severity) : var_export($severity, true), implode(', ', \EnumType\NotificationSeverityType::getValidValues())), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\Notification
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Notification
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\Notification
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get LocalizedMessage value
     * @return string|null
     */
    public function getLocalizedMessage()
    {
        return $this->LocalizedMessage;
    }
    /**
     * Set LocalizedMessage value
     * @param string $localizedMessage
     * @return \StructType\Notification
     */
    public function setLocalizedMessage($localizedMessage = null)
    {
        // validation for constraint: string
        if (!is_null($localizedMessage) && !is_string($localizedMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localizedMessage, true), gettype($localizedMessage)), __LINE__);
        }
        $this->LocalizedMessage = $localizedMessage;
        return $this;
    }
    /**
     * Get MessageParameters value
     * @return \StructType\NotificationParameter[]|null
     */
    public function getMessageParameters()
    {
        return $this->MessageParameters;
    }
    /**
     * This method is responsible for validating the values passed to the setMessageParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessageParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageParametersForArrayConstraintsFromSetMessageParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificationMessageParametersItem) {
            // validation for constraint: itemType
            if (!$notificationMessageParametersItem instanceof \StructType\NotificationParameter) {
                $invalidValues[] = is_object($notificationMessageParametersItem) ? get_class($notificationMessageParametersItem) : sprintf('%s(%s)', gettype($notificationMessageParametersItem), var_export($notificationMessageParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MessageParameters property can only contain items of type \StructType\NotificationParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MessageParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\NotificationParameter[] $messageParameters
     * @return \StructType\Notification
     */
    public function setMessageParameters(array $messageParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($messageParametersArrayErrorMessage = self::validateMessageParametersForArrayConstraintsFromSetMessageParameters($messageParameters))) {
            throw new \InvalidArgumentException($messageParametersArrayErrorMessage, __LINE__);
        }
        $this->MessageParameters = $messageParameters;
        return $this;
    }
    /**
     * Add item to MessageParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\NotificationParameter $item
     * @return \StructType\Notification
     */
    public function addToMessageParameters(\StructType\NotificationParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NotificationParameter) {
            throw new \InvalidArgumentException(sprintf('The MessageParameters property can only contain items of type \StructType\NotificationParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MessageParameters[] = $item;
        return $this;
    }
}
