<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Localization StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the representation of human-readable text.
 * @subpackage Structs
 */
class Localization extends AbstractStructBase
{
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - documentation: Two-letter code for language (e.g. EN, FR, etc.)
     * - minOccurs: 1
     * @var string
     */
    public $LanguageCode;
    /**
     * The LocaleCode
     * Meta information extracted from the WSDL
     * - documentation: Two-letter code for the region (e.g. us, ca, etc..).
     * - minOccurs: 0
     * @var string
     */
    public $LocaleCode;
    /**
     * Constructor method for Localization
     * @uses Localization::setLanguageCode()
     * @uses Localization::setLocaleCode()
     * @param string $languageCode
     * @param string $localeCode
     */
    public function __construct($languageCode = null, $localeCode = null)
    {
        $this
            ->setLanguageCode($languageCode)
            ->setLocaleCode($localeCode);
    }
    /**
     * Get LanguageCode value
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\Localization
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get LocaleCode value
     * @return string|null
     */
    public function getLocaleCode()
    {
        return $this->LocaleCode;
    }
    /**
     * Set LocaleCode value
     * @param string $localeCode
     * @return \StructType\Localization
     */
    public function setLocaleCode($localeCode = null)
    {
        // validation for constraint: string
        if (!is_null($localeCode) && !is_string($localeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localeCode, true), gettype($localeCode)), __LINE__);
        }
        $this->LocaleCode = $localeCode;
        return $this;
    }
}
