<?php

namespace GQ_\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewValidatedSecurityToken Structs
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewValidatedSecurityToken
 * @package GQ_
 * @subpackage Structs
 */
class GQ_ViewValidatedSecurityToken extends AbstractStructBase
{
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \GQ_\Structs\GQ_ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The ValidationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ValidationResult;
    /**
     * Constructor method for ViewValidatedSecurityToken
     * @uses GQ_ViewValidatedSecurityToken::setExceptions()
     * @uses GQ_ViewValidatedSecurityToken::setValidationResult()
     * @param \GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions
     * @param bool $validationResult
     */
    public function __construct(\GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions = null, $validationResult = null)
    {
        $this
            ->setExceptions($exceptions)
            ->setValidationResult($validationResult);
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GQ_\Structs\GQ_ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions
     * @return \GQ_\Structs\GQ_ViewValidatedSecurityToken
     */
    public function setExceptions(\GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
    /**
     * Get ValidationResult value
     * @return bool|null
     */
    public function getValidationResult()
    {
        return $this->ValidationResult;
    }
    /**
     * Set ValidationResult value
     * @param bool $validationResult
     * @return \GQ_\Structs\GQ_ViewValidatedSecurityToken
     */
    public function setValidationResult($validationResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($validationResult) && !is_bool($validationResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validationResult, true), gettype($validationResult)), __LINE__);
        }
        $this->ValidationResult = $validationResult;
        return $this;
    }
}
