<?php

namespace GQ_\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionInfo Structs
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionInfo
 * @package GQ_
 * @subpackage Structs
 */
class GQ_TransactionInfo extends AbstractStructBase
{
    /**
     * The SecurityGUID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SecurityGUID;
    /**
     * The CarrierCodes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \GQ_\Arrays\GQ_ArrayOfCarrierCode
     */
    public $CarrierCodes;
    /**
     * The ClientIPAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIPAddress;
    /**
     * The HistoricUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HistoricUserName;
    /**
     * Constructor method for TransactionInfo
     * @uses GQ_TransactionInfo::setSecurityGUID()
     * @uses GQ_TransactionInfo::setCarrierCodes()
     * @uses GQ_TransactionInfo::setClientIPAddress()
     * @uses GQ_TransactionInfo::setHistoricUserName()
     * @param string $securityGUID
     * @param \GQ_\Arrays\GQ_ArrayOfCarrierCode $carrierCodes
     * @param string $clientIPAddress
     * @param string $historicUserName
     */
    public function __construct($securityGUID = null, \GQ_\Arrays\GQ_ArrayOfCarrierCode $carrierCodes = null, $clientIPAddress = null, $historicUserName = null)
    {
        $this
            ->setSecurityGUID($securityGUID)
            ->setCarrierCodes($carrierCodes)
            ->setClientIPAddress($clientIPAddress)
            ->setHistoricUserName($historicUserName);
    }
    /**
     * Get SecurityGUID value
     * @return string|null
     */
    public function getSecurityGUID()
    {
        return $this->SecurityGUID;
    }
    /**
     * Set SecurityGUID value
     * @param string $securityGUID
     * @return \GQ_\Structs\GQ_TransactionInfo
     */
    public function setSecurityGUID($securityGUID = null)
    {
        // validation for constraint: string
        if (!is_null($securityGUID) && !is_string($securityGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityGUID, true), gettype($securityGUID)), __LINE__);
        }
        $this->SecurityGUID = $securityGUID;
        return $this;
    }
    /**
     * Get CarrierCodes value
     * @return \GQ_\Arrays\GQ_ArrayOfCarrierCode|null
     */
    public function getCarrierCodes()
    {
        return $this->CarrierCodes;
    }
    /**
     * Set CarrierCodes value
     * @param \GQ_\Arrays\GQ_ArrayOfCarrierCode $carrierCodes
     * @return \GQ_\Structs\GQ_TransactionInfo
     */
    public function setCarrierCodes(\GQ_\Arrays\GQ_ArrayOfCarrierCode $carrierCodes = null)
    {
        $this->CarrierCodes = $carrierCodes;
        return $this;
    }
    /**
     * Get ClientIPAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIPAddress()
    {
        return isset($this->ClientIPAddress) ? $this->ClientIPAddress : null;
    }
    /**
     * Set ClientIPAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIPAddress
     * @return \GQ_\Structs\GQ_TransactionInfo
     */
    public function setClientIPAddress($clientIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($clientIPAddress) && !is_string($clientIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIPAddress, true), gettype($clientIPAddress)), __LINE__);
        }
        if (is_null($clientIPAddress) || (is_array($clientIPAddress) && empty($clientIPAddress))) {
            unset($this->ClientIPAddress);
        } else {
            $this->ClientIPAddress = $clientIPAddress;
        }
        return $this;
    }
    /**
     * Get HistoricUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoricUserName()
    {
        return isset($this->HistoricUserName) ? $this->HistoricUserName : null;
    }
    /**
     * Set HistoricUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historicUserName
     * @return \GQ_\Structs\GQ_TransactionInfo
     */
    public function setHistoricUserName($historicUserName = null)
    {
        // validation for constraint: string
        if (!is_null($historicUserName) && !is_string($historicUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historicUserName, true), gettype($historicUserName)), __LINE__);
        }
        if (is_null($historicUserName) || (is_array($historicUserName) && empty($historicUserName))) {
            unset($this->HistoricUserName);
        } else {
            $this->HistoricUserName = $historicUserName;
        }
        return $this;
    }
}
