<?php

namespace GQ_\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionInformation.Exception Structs
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionInformation.Exception
 * @package GQ_
 * @subpackage Structs
 */
class GQ_ExceptionInformation_Exception extends AbstractStructBase
{
    /**
     * The ExceptionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExceptionCode;
    /**
     * The ExceptionDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionDescription;
    /**
     * The ExceptionSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionSource;
    /**
     * The ExceptionLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExceptionLevel;
    /**
     * Constructor method for ExceptionInformation.Exception
     * @uses GQ_ExceptionInformation_Exception::setExceptionCode()
     * @uses GQ_ExceptionInformation_Exception::setExceptionDescription()
     * @uses GQ_ExceptionInformation_Exception::setExceptionSource()
     * @uses GQ_ExceptionInformation_Exception::setExceptionLevel()
     * @param int $exceptionCode
     * @param string $exceptionDescription
     * @param string $exceptionSource
     * @param string $exceptionLevel
     */
    public function __construct($exceptionCode = null, $exceptionDescription = null, $exceptionSource = null, $exceptionLevel = null)
    {
        $this
            ->setExceptionCode($exceptionCode)
            ->setExceptionDescription($exceptionDescription)
            ->setExceptionSource($exceptionSource)
            ->setExceptionLevel($exceptionLevel);
    }
    /**
     * Get ExceptionCode value
     * @return int|null
     */
    public function getExceptionCode()
    {
        return $this->ExceptionCode;
    }
    /**
     * Set ExceptionCode value
     * @param int $exceptionCode
     * @return \GQ_\Structs\GQ_ExceptionInformation_Exception
     */
    public function setExceptionCode($exceptionCode = null)
    {
        // validation for constraint: int
        if (!is_null($exceptionCode) && !(is_int($exceptionCode) || ctype_digit($exceptionCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exceptionCode, true), gettype($exceptionCode)), __LINE__);
        }
        $this->ExceptionCode = $exceptionCode;
        return $this;
    }
    /**
     * Get ExceptionDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionDescription()
    {
        return isset($this->ExceptionDescription) ? $this->ExceptionDescription : null;
    }
    /**
     * Set ExceptionDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionDescription
     * @return \GQ_\Structs\GQ_ExceptionInformation_Exception
     */
    public function setExceptionDescription($exceptionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionDescription) && !is_string($exceptionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionDescription, true), gettype($exceptionDescription)), __LINE__);
        }
        if (is_null($exceptionDescription) || (is_array($exceptionDescription) && empty($exceptionDescription))) {
            unset($this->ExceptionDescription);
        } else {
            $this->ExceptionDescription = $exceptionDescription;
        }
        return $this;
    }
    /**
     * Get ExceptionSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionSource()
    {
        return isset($this->ExceptionSource) ? $this->ExceptionSource : null;
    }
    /**
     * Set ExceptionSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionSource
     * @return \GQ_\Structs\GQ_ExceptionInformation_Exception
     */
    public function setExceptionSource($exceptionSource = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionSource) && !is_string($exceptionSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionSource, true), gettype($exceptionSource)), __LINE__);
        }
        if (is_null($exceptionSource) || (is_array($exceptionSource) && empty($exceptionSource))) {
            unset($this->ExceptionSource);
        } else {
            $this->ExceptionSource = $exceptionSource;
        }
        return $this;
    }
    /**
     * Get ExceptionLevel value
     * @return string|null
     */
    public function getExceptionLevel()
    {
        return $this->ExceptionLevel;
    }
    /**
     * Set ExceptionLevel value
     * @uses \GQ_\Enums\GQ_ExceptionLevels::valueIsValid()
     * @uses \GQ_\Enums\GQ_ExceptionLevels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exceptionLevel
     * @return \GQ_\Structs\GQ_ExceptionInformation_Exception
     */
    public function setExceptionLevel($exceptionLevel = null)
    {
        // validation for constraint: enumeration
        if (!\GQ_\Enums\GQ_ExceptionLevels::valueIsValid($exceptionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \GQ_\Enums\GQ_ExceptionLevels', is_array($exceptionLevel) ? implode(', ', $exceptionLevel) : var_export($exceptionLevel, true), implode(', ', \GQ_\Enums\GQ_ExceptionLevels::getValidValues())), __LINE__);
        }
        $this->ExceptionLevel = $exceptionLevel;
        return $this;
    }
}
