<?php

namespace GQ_\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate Services
 * @package GQ_
 * @subpackage Services
 */
class GQ_Validate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidateSecurityToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GQ_\Structs\GQ_ValidateSecurityToken $parameters
     * @return \GQ_\Structs\GQ_ValidateSecurityTokenResponse|bool
     */
    public function ValidateSecurityToken(\GQ_\Structs\GQ_ValidateSecurityToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateSecurityToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GQ_\Structs\GQ_ValidateSecurityTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
