<?php

namespace GQ_\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewSecurityToken Structs
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewSecurityToken
 * @package GQ_
 * @subpackage Structs
 */
class GQ_ViewSecurityToken extends AbstractStructBase
{
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \GQ_\Structs\GQ_ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The SecurityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityToken;
    /**
     * Constructor method for ViewSecurityToken
     * @uses GQ_ViewSecurityToken::setExceptions()
     * @uses GQ_ViewSecurityToken::setSecurityToken()
     * @param \GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions
     * @param string $securityToken
     */
    public function __construct(\GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions = null, $securityToken = null)
    {
        $this
            ->setExceptions($exceptions)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GQ_\Structs\GQ_ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions
     * @return \GQ_\Structs\GQ_ViewSecurityToken
     */
    public function setExceptions(\GQ_\Structs\GQ_ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
    /**
     * Get SecurityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->SecurityToken) ? $this->SecurityToken : null;
    }
    /**
     * Set SecurityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \GQ_\Structs\GQ_ViewSecurityToken
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->SecurityToken);
        } else {
            $this->SecurityToken = $securityToken;
        }
        return $this;
    }
}
