<?php

namespace GQ_\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierCode Structs
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CarrierCode
 * @package GQ_
 * @subpackage Structs
 */
class GQ_CarrierCode extends AbstractStructBase
{
    /**
     * The AccessibleCarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccessibleCarrierCode;
    /**
     * Constructor method for CarrierCode
     * @uses GQ_CarrierCode::setAccessibleCarrierCode()
     * @param string $accessibleCarrierCode
     */
    public function __construct($accessibleCarrierCode = null)
    {
        $this
            ->setAccessibleCarrierCode($accessibleCarrierCode);
    }
    /**
     * Get AccessibleCarrierCode value
     * @return string|null
     */
    public function getAccessibleCarrierCode()
    {
        return $this->AccessibleCarrierCode;
    }
    /**
     * Set AccessibleCarrierCode value
     * @param string $accessibleCarrierCode
     * @return \GQ_\Structs\GQ_CarrierCode
     */
    public function setAccessibleCarrierCode($accessibleCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($accessibleCarrierCode) && !is_string($accessibleCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessibleCarrierCode, true), gettype($accessibleCarrierCode)), __LINE__);
        }
        $this->AccessibleCarrierCode = $accessibleCarrierCode;
        return $this;
    }
}
