<?php

namespace GQ_\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateSecurityToken Structs
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateSecurityToken
 * @package GQ_
 * @subpackage Structs
 */
class GQ_ValidateSecurityToken extends GQ_CarrierInfo
{
    /**
     * The ValidateSecurityTokenRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \GQ_\Structs\GQ_ValidateSecurityToken
     */
    public $ValidateSecurityTokenRequest;
    /**
     * The SecurityToken
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SecurityToken;
    /**
     * Constructor method for ValidateSecurityToken
     * @uses GQ_ValidateSecurityToken::setValidateSecurityTokenRequest()
     * @uses GQ_ValidateSecurityToken::setSecurityToken()
     * @param \GQ_\Structs\GQ_ValidateSecurityToken $validateSecurityTokenRequest
     * @param string $securityToken
     */
    public function __construct(\GQ_\Structs\GQ_ValidateSecurityToken $validateSecurityTokenRequest = null, $securityToken = null)
    {
        $this
            ->setValidateSecurityTokenRequest($validateSecurityTokenRequest)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get ValidateSecurityTokenRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GQ_\Structs\GQ_ValidateSecurityToken|null
     */
    public function getValidateSecurityTokenRequest()
    {
        return isset($this->ValidateSecurityTokenRequest) ? $this->ValidateSecurityTokenRequest : null;
    }
    /**
     * Set ValidateSecurityTokenRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \GQ_\Structs\GQ_ValidateSecurityToken $validateSecurityTokenRequest
     * @return \GQ_\Structs\GQ_ValidateSecurityToken
     */
    public function setValidateSecurityTokenRequest(\GQ_\Structs\GQ_ValidateSecurityToken $validateSecurityTokenRequest = null)
    {
        if (is_null($validateSecurityTokenRequest) || (is_array($validateSecurityTokenRequest) && empty($validateSecurityTokenRequest))) {
            unset($this->ValidateSecurityTokenRequest);
        } else {
            $this->ValidateSecurityTokenRequest = $validateSecurityTokenRequest;
        }
        return $this;
    }
    /**
     * Get SecurityToken value
     * @return string|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * Set SecurityToken value
     * @param string $securityToken
     * @return \GQ_\Structs\GQ_ValidateSecurityToken
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        $this->SecurityToken = $securityToken;
        return $this;
    }
}
