<?php

namespace GQ_\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupDataResChannel Structs
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupDataResChannel
 * @package GQ_
 * @subpackage Structs
 */
class GQ_GroupDataResChannel extends AbstractStructBase
{
    /**
     * The ResChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResChannel;
    /**
     * Constructor method for GroupDataResChannel
     * @uses GQ_GroupDataResChannel::setResChannel()
     * @param string $resChannel
     */
    public function __construct($resChannel = null)
    {
        $this
            ->setResChannel($resChannel);
    }
    /**
     * Get ResChannel value
     * @return string|null
     */
    public function getResChannel()
    {
        return $this->ResChannel;
    }
    /**
     * Set ResChannel value
     * @uses \GQ_\Enums\GQ_Enumerations_ReservationChannelTypes::valueIsValid()
     * @uses \GQ_\Enums\GQ_Enumerations_ReservationChannelTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resChannel
     * @return \GQ_\Structs\GQ_GroupDataResChannel
     */
    public function setResChannel($resChannel = null)
    {
        // validation for constraint: enumeration
        if (!\GQ_\Enums\GQ_Enumerations_ReservationChannelTypes::valueIsValid($resChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \GQ_\Enums\GQ_Enumerations_ReservationChannelTypes', is_array($resChannel) ? implode(', ', $resChannel) : var_export($resChannel, true), implode(', ', \GQ_\Enums\GQ_Enumerations_ReservationChannelTypes::getValidValues())), __LINE__);
        }
        $this->ResChannel = $resChannel;
        return $this;
    }
}
