<?php

namespace GQ_\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve Services
 * @package GQ_
 * @subpackage Services
 */
class GQ_Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveSecurityToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GQ_\Structs\GQ_RetrieveSecurityToken $parameters
     * @return \GQ_\Structs\GQ_RetrieveSecurityTokenResponse|bool
     */
    public function RetrieveSecurityToken(\GQ_\Structs\GQ_RetrieveSecurityToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSecurityToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GQ_\Structs\GQ_RetrieveSecurityTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
