<?php

namespace GQ_\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get Services
 * @package GQ_
 * @subpackage Services
 */
class GQ_Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetGroupDataByUserid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GQ_\Structs\GQ_GetGroupDataByUserid $parameters
     * @return \GQ_\Structs\GQ_GetGroupDataByUseridResponse|bool
     */
    public function GetGroupDataByUserid(\GQ_\Structs\GQ_GetGroupDataByUserid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGroupDataByUserid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GQ_\Structs\GQ_GetGroupDataByUseridResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
