<?php

namespace GQ_\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCarrierCode Arrays
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCarrierCode
 * @package GQ_
 * @subpackage Arrays
 */
class GQ_ArrayOfCarrierCode extends AbstractStructArrayBase
{
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GQ_\Structs\GQ_CarrierCode[]
     */
    public $CarrierCode;
    /**
     * Constructor method for ArrayOfCarrierCode
     * @uses GQ_ArrayOfCarrierCode::setCarrierCode()
     * @param \GQ_\Structs\GQ_CarrierCode[] $carrierCode
     */
    public function __construct(array $carrierCode = array())
    {
        $this
            ->setCarrierCode($carrierCode);
    }
    /**
     * Get CarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GQ_\Structs\GQ_CarrierCode[]|null
     */
    public function getCarrierCode()
    {
        return isset($this->CarrierCode) ? $this->CarrierCode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierCodeForArrayConstraintsFromSetCarrierCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCarrierCodeCarrierCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfCarrierCodeCarrierCodeItem instanceof \GQ_\Structs\GQ_CarrierCode) {
                $invalidValues[] = is_object($arrayOfCarrierCodeCarrierCodeItem) ? get_class($arrayOfCarrierCodeCarrierCodeItem) : sprintf('%s(%s)', gettype($arrayOfCarrierCodeCarrierCodeItem), var_export($arrayOfCarrierCodeCarrierCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierCode property can only contain items of type \GQ_\Structs\GQ_CarrierCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GQ_\Structs\GQ_CarrierCode[] $carrierCode
     * @return \GQ_\Arrays\GQ_ArrayOfCarrierCode
     */
    public function setCarrierCode(array $carrierCode = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierCodeArrayErrorMessage = self::validateCarrierCodeForArrayConstraintsFromSetCarrierCode($carrierCode))) {
            throw new \InvalidArgumentException($carrierCodeArrayErrorMessage, __LINE__);
        }
        if (is_null($carrierCode) || (is_array($carrierCode) && empty($carrierCode))) {
            unset($this->CarrierCode);
        } else {
            $this->CarrierCode = $carrierCode;
        }
        return $this;
    }
    /**
     * Add item to CarrierCode value
     * @throws \InvalidArgumentException
     * @param \GQ_\Structs\GQ_CarrierCode $item
     * @return \GQ_\Arrays\GQ_ArrayOfCarrierCode
     */
    public function addToCarrierCode(\GQ_\Structs\GQ_CarrierCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GQ_\Structs\GQ_CarrierCode) {
            throw new \InvalidArgumentException(sprintf('The CarrierCode property can only contain items of type \GQ_\Structs\GQ_CarrierCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GQ_\Structs\GQ_CarrierCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GQ_\Structs\GQ_CarrierCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GQ_\Structs\GQ_CarrierCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GQ_\Structs\GQ_CarrierCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GQ_\Structs\GQ_CarrierCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CarrierCode
     */
    public function getAttributeName()
    {
        return 'CarrierCode';
    }
}
