<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoginUsuarioCertificado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginUsuarioCertificado $parameters
     * @return \StructType\LoginUsuarioCertificadoResponse|bool
     */
    public function LoginUsuarioCertificado(\StructType\LoginUsuarioCertificado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginUsuarioCertificado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoginUsuarioCertificadoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
