<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for solicitudVerificarNit StructType
 * @subpackage Structs
 */
class SolicitudVerificarNit extends AbstractStructBase
{
    /**
     * The codigoAmbiente
     * @var int
     */
    public $codigoAmbiente;
    /**
     * The codigoModalidad
     * @var int
     */
    public $codigoModalidad;
    /**
     * The codigoSistema
     * @var string
     */
    public $codigoSistema;
    /**
     * The codigoSucursal
     * @var int
     */
    public $codigoSucursal;
    /**
     * The cuis
     * @var string
     */
    public $cuis;
    /**
     * The nit
     * @var int
     */
    public $nit;
    /**
     * The nitParaVerificacion
     * @var int
     */
    public $nitParaVerificacion;
    /**
     * Constructor method for solicitudVerificarNit
     * @uses SolicitudVerificarNit::setCodigoAmbiente()
     * @uses SolicitudVerificarNit::setCodigoModalidad()
     * @uses SolicitudVerificarNit::setCodigoSistema()
     * @uses SolicitudVerificarNit::setCodigoSucursal()
     * @uses SolicitudVerificarNit::setCuis()
     * @uses SolicitudVerificarNit::setNit()
     * @uses SolicitudVerificarNit::setNitParaVerificacion()
     * @param int $codigoAmbiente
     * @param int $codigoModalidad
     * @param string $codigoSistema
     * @param int $codigoSucursal
     * @param string $cuis
     * @param int $nit
     * @param int $nitParaVerificacion
     */
    public function __construct($codigoAmbiente = null, $codigoModalidad = null, $codigoSistema = null, $codigoSucursal = null, $cuis = null, $nit = null, $nitParaVerificacion = null)
    {
        $this
            ->setCodigoAmbiente($codigoAmbiente)
            ->setCodigoModalidad($codigoModalidad)
            ->setCodigoSistema($codigoSistema)
            ->setCodigoSucursal($codigoSucursal)
            ->setCuis($cuis)
            ->setNit($nit)
            ->setNitParaVerificacion($nitParaVerificacion);
    }
    /**
     * Get codigoAmbiente value
     * @return int|null
     */
    public function getCodigoAmbiente()
    {
        return $this->codigoAmbiente;
    }
    /**
     * Set codigoAmbiente value
     * @param int $codigoAmbiente
     * @return \StructType\SolicitudVerificarNit
     */
    public function setCodigoAmbiente($codigoAmbiente = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAmbiente) && !(is_int($codigoAmbiente) || ctype_digit($codigoAmbiente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAmbiente, true), gettype($codigoAmbiente)), __LINE__);
        }
        $this->codigoAmbiente = $codigoAmbiente;
        return $this;
    }
    /**
     * Get codigoModalidad value
     * @return int|null
     */
    public function getCodigoModalidad()
    {
        return $this->codigoModalidad;
    }
    /**
     * Set codigoModalidad value
     * @param int $codigoModalidad
     * @return \StructType\SolicitudVerificarNit
     */
    public function setCodigoModalidad($codigoModalidad = null)
    {
        // validation for constraint: int
        if (!is_null($codigoModalidad) && !(is_int($codigoModalidad) || ctype_digit($codigoModalidad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoModalidad, true), gettype($codigoModalidad)), __LINE__);
        }
        $this->codigoModalidad = $codigoModalidad;
        return $this;
    }
    /**
     * Get codigoSistema value
     * @return string|null
     */
    public function getCodigoSistema()
    {
        return $this->codigoSistema;
    }
    /**
     * Set codigoSistema value
     * @param string $codigoSistema
     * @return \StructType\SolicitudVerificarNit
     */
    public function setCodigoSistema($codigoSistema = null)
    {
        // validation for constraint: string
        if (!is_null($codigoSistema) && !is_string($codigoSistema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoSistema, true), gettype($codigoSistema)), __LINE__);
        }
        $this->codigoSistema = $codigoSistema;
        return $this;
    }
    /**
     * Get codigoSucursal value
     * @return int|null
     */
    public function getCodigoSucursal()
    {
        return $this->codigoSucursal;
    }
    /**
     * Set codigoSucursal value
     * @param int $codigoSucursal
     * @return \StructType\SolicitudVerificarNit
     */
    public function setCodigoSucursal($codigoSucursal = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSucursal) && !(is_int($codigoSucursal) || ctype_digit($codigoSucursal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSucursal, true), gettype($codigoSucursal)), __LINE__);
        }
        $this->codigoSucursal = $codigoSucursal;
        return $this;
    }
    /**
     * Get cuis value
     * @return string|null
     */
    public function getCuis()
    {
        return $this->cuis;
    }
    /**
     * Set cuis value
     * @param string $cuis
     * @return \StructType\SolicitudVerificarNit
     */
    public function setCuis($cuis = null)
    {
        // validation for constraint: string
        if (!is_null($cuis) && !is_string($cuis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cuis, true), gettype($cuis)), __LINE__);
        }
        $this->cuis = $cuis;
        return $this;
    }
    /**
     * Get nit value
     * @return int|null
     */
    public function getNit()
    {
        return $this->nit;
    }
    /**
     * Set nit value
     * @param int $nit
     * @return \StructType\SolicitudVerificarNit
     */
    public function setNit($nit = null)
    {
        // validation for constraint: int
        if (!is_null($nit) && !(is_int($nit) || ctype_digit($nit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nit, true), gettype($nit)), __LINE__);
        }
        $this->nit = $nit;
        return $this;
    }
    /**
     * Get nitParaVerificacion value
     * @return int|null
     */
    public function getNitParaVerificacion()
    {
        return $this->nitParaVerificacion;
    }
    /**
     * Set nitParaVerificacion value
     * @param int $nitParaVerificacion
     * @return \StructType\SolicitudVerificarNit
     */
    public function setNitParaVerificacion($nitParaVerificacion = null)
    {
        // validation for constraint: int
        if (!is_null($nitParaVerificacion) && !(is_int($nitParaVerificacion) || ctype_digit($nitParaVerificacion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nitParaVerificacion, true), gettype($nitParaVerificacion)), __LINE__);
        }
        $this->nitParaVerificacion = $nitParaVerificacion;
        return $this;
    }
}
