<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for solicitudNotifcaRevocado StructType
 * @subpackage Structs
 */
class SolicitudNotifcaRevocado extends AbstractStructBase
{
    /**
     * The certificado
     * @var string
     */
    public $certificado;
    /**
     * The codigoAmbiente
     * @var int
     */
    public $codigoAmbiente;
    /**
     * The codigoSistema
     * @var string
     */
    public $codigoSistema;
    /**
     * The codigoSucursal
     * @var int
     */
    public $codigoSucursal;
    /**
     * The cuis
     * @var string
     */
    public $cuis;
    /**
     * The fechaRevocacion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fechaRevocacion;
    /**
     * The nit
     * @var int
     */
    public $nit;
    /**
     * The razonRevocacion
     * @var string
     */
    public $razonRevocacion;
    /**
     * Constructor method for solicitudNotifcaRevocado
     * @uses SolicitudNotifcaRevocado::setCertificado()
     * @uses SolicitudNotifcaRevocado::setCodigoAmbiente()
     * @uses SolicitudNotifcaRevocado::setCodigoSistema()
     * @uses SolicitudNotifcaRevocado::setCodigoSucursal()
     * @uses SolicitudNotifcaRevocado::setCuis()
     * @uses SolicitudNotifcaRevocado::setFechaRevocacion()
     * @uses SolicitudNotifcaRevocado::setNit()
     * @uses SolicitudNotifcaRevocado::setRazonRevocacion()
     * @param string $certificado
     * @param int $codigoAmbiente
     * @param string $codigoSistema
     * @param int $codigoSucursal
     * @param string $cuis
     * @param string $fechaRevocacion
     * @param int $nit
     * @param string $razonRevocacion
     */
    public function __construct($certificado = null, $codigoAmbiente = null, $codigoSistema = null, $codigoSucursal = null, $cuis = null, $fechaRevocacion = null, $nit = null, $razonRevocacion = null)
    {
        $this
            ->setCertificado($certificado)
            ->setCodigoAmbiente($codigoAmbiente)
            ->setCodigoSistema($codigoSistema)
            ->setCodigoSucursal($codigoSucursal)
            ->setCuis($cuis)
            ->setFechaRevocacion($fechaRevocacion)
            ->setNit($nit)
            ->setRazonRevocacion($razonRevocacion);
    }
    /**
     * Get certificado value
     * @return string|null
     */
    public function getCertificado()
    {
        return $this->certificado;
    }
    /**
     * Set certificado value
     * @param string $certificado
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setCertificado($certificado = null)
    {
        // validation for constraint: string
        if (!is_null($certificado) && !is_string($certificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificado, true), gettype($certificado)), __LINE__);
        }
        $this->certificado = $certificado;
        return $this;
    }
    /**
     * Get codigoAmbiente value
     * @return int|null
     */
    public function getCodigoAmbiente()
    {
        return $this->codigoAmbiente;
    }
    /**
     * Set codigoAmbiente value
     * @param int $codigoAmbiente
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setCodigoAmbiente($codigoAmbiente = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAmbiente) && !(is_int($codigoAmbiente) || ctype_digit($codigoAmbiente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAmbiente, true), gettype($codigoAmbiente)), __LINE__);
        }
        $this->codigoAmbiente = $codigoAmbiente;
        return $this;
    }
    /**
     * Get codigoSistema value
     * @return string|null
     */
    public function getCodigoSistema()
    {
        return $this->codigoSistema;
    }
    /**
     * Set codigoSistema value
     * @param string $codigoSistema
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setCodigoSistema($codigoSistema = null)
    {
        // validation for constraint: string
        if (!is_null($codigoSistema) && !is_string($codigoSistema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoSistema, true), gettype($codigoSistema)), __LINE__);
        }
        $this->codigoSistema = $codigoSistema;
        return $this;
    }
    /**
     * Get codigoSucursal value
     * @return int|null
     */
    public function getCodigoSucursal()
    {
        return $this->codigoSucursal;
    }
    /**
     * Set codigoSucursal value
     * @param int $codigoSucursal
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setCodigoSucursal($codigoSucursal = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSucursal) && !(is_int($codigoSucursal) || ctype_digit($codigoSucursal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSucursal, true), gettype($codigoSucursal)), __LINE__);
        }
        $this->codigoSucursal = $codigoSucursal;
        return $this;
    }
    /**
     * Get cuis value
     * @return string|null
     */
    public function getCuis()
    {
        return $this->cuis;
    }
    /**
     * Set cuis value
     * @param string $cuis
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setCuis($cuis = null)
    {
        // validation for constraint: string
        if (!is_null($cuis) && !is_string($cuis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cuis, true), gettype($cuis)), __LINE__);
        }
        $this->cuis = $cuis;
        return $this;
    }
    /**
     * Get fechaRevocacion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFechaRevocacion()
    {
        return isset($this->fechaRevocacion) ? $this->fechaRevocacion : null;
    }
    /**
     * Set fechaRevocacion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fechaRevocacion
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setFechaRevocacion($fechaRevocacion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaRevocacion) && !is_string($fechaRevocacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaRevocacion, true), gettype($fechaRevocacion)), __LINE__);
        }
        if (is_null($fechaRevocacion) || (is_array($fechaRevocacion) && empty($fechaRevocacion))) {
            unset($this->fechaRevocacion);
        } else {
            $this->fechaRevocacion = $fechaRevocacion;
        }
        return $this;
    }
    /**
     * Get nit value
     * @return int|null
     */
    public function getNit()
    {
        return $this->nit;
    }
    /**
     * Set nit value
     * @param int $nit
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setNit($nit = null)
    {
        // validation for constraint: int
        if (!is_null($nit) && !(is_int($nit) || ctype_digit($nit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nit, true), gettype($nit)), __LINE__);
        }
        $this->nit = $nit;
        return $this;
    }
    /**
     * Get razonRevocacion value
     * @return string|null
     */
    public function getRazonRevocacion()
    {
        return $this->razonRevocacion;
    }
    /**
     * Set razonRevocacion value
     * @param string $razonRevocacion
     * @return \StructType\SolicitudNotifcaRevocado
     */
    public function setRazonRevocacion($razonRevocacion = null)
    {
        // validation for constraint: string
        if (!is_null($razonRevocacion) && !is_string($razonRevocacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($razonRevocacion, true), gettype($razonRevocacion)), __LINE__);
        }
        $this->razonRevocacion = $razonRevocacion;
        return $this;
    }
}
