<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for solicitudCuis StructType
 * @subpackage Structs
 */
class SolicitudCuis extends AbstractStructBase
{
    /**
     * The codigoAmbiente
     * @var int
     */
    public $codigoAmbiente;
    /**
     * The codigoModalidad
     * @var int
     */
    public $codigoModalidad;
    /**
     * The codigoPuntoVenta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $codigoPuntoVenta;
    /**
     * The codigoSistema
     * @var string
     */
    public $codigoSistema;
    /**
     * The codigoSucursal
     * @var int
     */
    public $codigoSucursal;
    /**
     * The nit
     * @var int
     */
    public $nit;
    /**
     * Constructor method for solicitudCuis
     * @uses SolicitudCuis::setCodigoAmbiente()
     * @uses SolicitudCuis::setCodigoModalidad()
     * @uses SolicitudCuis::setCodigoPuntoVenta()
     * @uses SolicitudCuis::setCodigoSistema()
     * @uses SolicitudCuis::setCodigoSucursal()
     * @uses SolicitudCuis::setNit()
     * @param int $codigoAmbiente
     * @param int $codigoModalidad
     * @param int $codigoPuntoVenta
     * @param string $codigoSistema
     * @param int $codigoSucursal
     * @param int $nit
     */
    public function __construct($codigoAmbiente = null, $codigoModalidad = null, $codigoPuntoVenta = null, $codigoSistema = null, $codigoSucursal = null, $nit = null)
    {
        $this
            ->setCodigoAmbiente($codigoAmbiente)
            ->setCodigoModalidad($codigoModalidad)
            ->setCodigoPuntoVenta($codigoPuntoVenta)
            ->setCodigoSistema($codigoSistema)
            ->setCodigoSucursal($codigoSucursal)
            ->setNit($nit);
    }
    /**
     * Get codigoAmbiente value
     * @return int|null
     */
    public function getCodigoAmbiente()
    {
        return $this->codigoAmbiente;
    }
    /**
     * Set codigoAmbiente value
     * @param int $codigoAmbiente
     * @return \StructType\SolicitudCuis
     */
    public function setCodigoAmbiente($codigoAmbiente = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAmbiente) && !(is_int($codigoAmbiente) || ctype_digit($codigoAmbiente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAmbiente, true), gettype($codigoAmbiente)), __LINE__);
        }
        $this->codigoAmbiente = $codigoAmbiente;
        return $this;
    }
    /**
     * Get codigoModalidad value
     * @return int|null
     */
    public function getCodigoModalidad()
    {
        return $this->codigoModalidad;
    }
    /**
     * Set codigoModalidad value
     * @param int $codigoModalidad
     * @return \StructType\SolicitudCuis
     */
    public function setCodigoModalidad($codigoModalidad = null)
    {
        // validation for constraint: int
        if (!is_null($codigoModalidad) && !(is_int($codigoModalidad) || ctype_digit($codigoModalidad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoModalidad, true), gettype($codigoModalidad)), __LINE__);
        }
        $this->codigoModalidad = $codigoModalidad;
        return $this;
    }
    /**
     * Get codigoPuntoVenta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodigoPuntoVenta()
    {
        return isset($this->codigoPuntoVenta) ? $this->codigoPuntoVenta : null;
    }
    /**
     * Set codigoPuntoVenta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codigoPuntoVenta
     * @return \StructType\SolicitudCuis
     */
    public function setCodigoPuntoVenta($codigoPuntoVenta = null)
    {
        // validation for constraint: int
        if (!is_null($codigoPuntoVenta) && !(is_int($codigoPuntoVenta) || ctype_digit($codigoPuntoVenta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoPuntoVenta, true), gettype($codigoPuntoVenta)), __LINE__);
        }
        if (is_null($codigoPuntoVenta) || (is_array($codigoPuntoVenta) && empty($codigoPuntoVenta))) {
            unset($this->codigoPuntoVenta);
        } else {
            $this->codigoPuntoVenta = $codigoPuntoVenta;
        }
        return $this;
    }
    /**
     * Get codigoSistema value
     * @return string|null
     */
    public function getCodigoSistema()
    {
        return $this->codigoSistema;
    }
    /**
     * Set codigoSistema value
     * @param string $codigoSistema
     * @return \StructType\SolicitudCuis
     */
    public function setCodigoSistema($codigoSistema = null)
    {
        // validation for constraint: string
        if (!is_null($codigoSistema) && !is_string($codigoSistema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoSistema, true), gettype($codigoSistema)), __LINE__);
        }
        $this->codigoSistema = $codigoSistema;
        return $this;
    }
    /**
     * Get codigoSucursal value
     * @return int|null
     */
    public function getCodigoSucursal()
    {
        return $this->codigoSucursal;
    }
    /**
     * Set codigoSucursal value
     * @param int $codigoSucursal
     * @return \StructType\SolicitudCuis
     */
    public function setCodigoSucursal($codigoSucursal = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSucursal) && !(is_int($codigoSucursal) || ctype_digit($codigoSucursal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSucursal, true), gettype($codigoSucursal)), __LINE__);
        }
        $this->codigoSucursal = $codigoSucursal;
        return $this;
    }
    /**
     * Get nit value
     * @return int|null
     */
    public function getNit()
    {
        return $this->nit;
    }
    /**
     * Set nit value
     * @param int $nit
     * @return \StructType\SolicitudCuis
     */
    public function setNit($nit = null)
    {
        // validation for constraint: int
        if (!is_null($nit) && !(is_int($nit) || ctype_digit($nit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nit, true), gettype($nit)), __LINE__);
        }
        $this->nit = $nit;
        return $this;
    }
}
