<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for solicitudCufdMasivo StructType
 * @subpackage Structs
 */
class SolicitudCufdMasivo extends AbstractStructBase
{
    /**
     * The codigoAmbiente
     * @var int
     */
    public $codigoAmbiente;
    /**
     * The codigoModalidad
     * @var int
     */
    public $codigoModalidad;
    /**
     * The codigoSistema
     * @var string
     */
    public $codigoSistema;
    /**
     * The datosSolicitud
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SolicitudListaCufdDto[]
     */
    public $datosSolicitud;
    /**
     * The nit
     * @var int
     */
    public $nit;
    /**
     * Constructor method for solicitudCufdMasivo
     * @uses SolicitudCufdMasivo::setCodigoAmbiente()
     * @uses SolicitudCufdMasivo::setCodigoModalidad()
     * @uses SolicitudCufdMasivo::setCodigoSistema()
     * @uses SolicitudCufdMasivo::setDatosSolicitud()
     * @uses SolicitudCufdMasivo::setNit()
     * @param int $codigoAmbiente
     * @param int $codigoModalidad
     * @param string $codigoSistema
     * @param \StructType\SolicitudListaCufdDto[] $datosSolicitud
     * @param int $nit
     */
    public function __construct($codigoAmbiente = null, $codigoModalidad = null, $codigoSistema = null, array $datosSolicitud = array(), $nit = null)
    {
        $this
            ->setCodigoAmbiente($codigoAmbiente)
            ->setCodigoModalidad($codigoModalidad)
            ->setCodigoSistema($codigoSistema)
            ->setDatosSolicitud($datosSolicitud)
            ->setNit($nit);
    }
    /**
     * Get codigoAmbiente value
     * @return int|null
     */
    public function getCodigoAmbiente()
    {
        return $this->codigoAmbiente;
    }
    /**
     * Set codigoAmbiente value
     * @param int $codigoAmbiente
     * @return \StructType\SolicitudCufdMasivo
     */
    public function setCodigoAmbiente($codigoAmbiente = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAmbiente) && !(is_int($codigoAmbiente) || ctype_digit($codigoAmbiente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAmbiente, true), gettype($codigoAmbiente)), __LINE__);
        }
        $this->codigoAmbiente = $codigoAmbiente;
        return $this;
    }
    /**
     * Get codigoModalidad value
     * @return int|null
     */
    public function getCodigoModalidad()
    {
        return $this->codigoModalidad;
    }
    /**
     * Set codigoModalidad value
     * @param int $codigoModalidad
     * @return \StructType\SolicitudCufdMasivo
     */
    public function setCodigoModalidad($codigoModalidad = null)
    {
        // validation for constraint: int
        if (!is_null($codigoModalidad) && !(is_int($codigoModalidad) || ctype_digit($codigoModalidad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoModalidad, true), gettype($codigoModalidad)), __LINE__);
        }
        $this->codigoModalidad = $codigoModalidad;
        return $this;
    }
    /**
     * Get codigoSistema value
     * @return string|null
     */
    public function getCodigoSistema()
    {
        return $this->codigoSistema;
    }
    /**
     * Set codigoSistema value
     * @param string $codigoSistema
     * @return \StructType\SolicitudCufdMasivo
     */
    public function setCodigoSistema($codigoSistema = null)
    {
        // validation for constraint: string
        if (!is_null($codigoSistema) && !is_string($codigoSistema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoSistema, true), gettype($codigoSistema)), __LINE__);
        }
        $this->codigoSistema = $codigoSistema;
        return $this;
    }
    /**
     * Get datosSolicitud value
     * @return \StructType\SolicitudListaCufdDto[]|null
     */
    public function getDatosSolicitud()
    {
        return $this->datosSolicitud;
    }
    /**
     * This method is responsible for validating the values passed to the setDatosSolicitud method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatosSolicitud method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatosSolicitudForArrayConstraintsFromSetDatosSolicitud(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $solicitudCufdMasivoDatosSolicitudItem) {
            // validation for constraint: itemType
            if (!$solicitudCufdMasivoDatosSolicitudItem instanceof \StructType\SolicitudListaCufdDto) {
                $invalidValues[] = is_object($solicitudCufdMasivoDatosSolicitudItem) ? get_class($solicitudCufdMasivoDatosSolicitudItem) : sprintf('%s(%s)', gettype($solicitudCufdMasivoDatosSolicitudItem), var_export($solicitudCufdMasivoDatosSolicitudItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The datosSolicitud property can only contain items of type \StructType\SolicitudListaCufdDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set datosSolicitud value
     * @throws \InvalidArgumentException
     * @param \StructType\SolicitudListaCufdDto[] $datosSolicitud
     * @return \StructType\SolicitudCufdMasivo
     */
    public function setDatosSolicitud(array $datosSolicitud = array())
    {
        // validation for constraint: array
        if ('' !== ($datosSolicitudArrayErrorMessage = self::validateDatosSolicitudForArrayConstraintsFromSetDatosSolicitud($datosSolicitud))) {
            throw new \InvalidArgumentException($datosSolicitudArrayErrorMessage, __LINE__);
        }
        $this->datosSolicitud = $datosSolicitud;
        return $this;
    }
    /**
     * Add item to datosSolicitud value
     * @throws \InvalidArgumentException
     * @param \StructType\SolicitudListaCufdDto $item
     * @return \StructType\SolicitudCufdMasivo
     */
    public function addToDatosSolicitud(\StructType\SolicitudListaCufdDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SolicitudListaCufdDto) {
            throw new \InvalidArgumentException(sprintf('The datosSolicitud property can only contain items of type \StructType\SolicitudListaCufdDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->datosSolicitud[] = $item;
        return $this;
    }
    /**
     * Get nit value
     * @return int|null
     */
    public function getNit()
    {
        return $this->nit;
    }
    /**
     * Set nit value
     * @param int $nit
     * @return \StructType\SolicitudCufdMasivo
     */
    public function setNit($nit = null)
    {
        // validation for constraint: int
        if (!is_null($nit) && !(is_int($nit) || ctype_digit($nit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nit, true), gettype($nit)), __LINE__);
        }
        $this->nit = $nit;
        return $this;
    }
}
