<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Notifica ServiceType
 * @subpackage Services
 */
class Notifica extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named notificaCertificadoRevocado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NotificaCertificadoRevocado $parameters
     * @return \StructType\NotificaCertificadoRevocadoResponse|bool
     */
    public function notificaCertificadoRevocado(\StructType\NotificaCertificadoRevocado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->notificaCertificadoRevocado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NotificaCertificadoRevocadoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
