<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pilotosiatservicios.impuestos.gob.bo/v2/FacturacionCodigos?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pilotosiatservicios.impuestos.gob.bo/v2/FacturacionCodigos?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Verificar ServiceType
 */
$verificar = new \ServiceType\Verificar($options);
/**
 * Sample call for verificarNit operation/method
 */
if ($verificar->verificarNit(new \StructType\VerificarNit()) !== false) {
    print_r($verificar->getResult());
} else {
    print_r($verificar->getLastError());
}
/**
 * Sample call for verificarComunicacion operation/method
 */
if ($verificar->verificarComunicacion(new \StructType\VerificarComunicacion()) !== false) {
    print_r($verificar->getResult());
} else {
    print_r($verificar->getLastError());
}
/**
 * Samples for Cuis ServiceType
 */
$cuis = new \ServiceType\Cuis($options);
/**
 * Sample call for cuisMasivo operation/method
 */
if ($cuis->cuisMasivo(new \StructType\CuisMasivo()) !== false) {
    print_r($cuis->getResult());
} else {
    print_r($cuis->getLastError());
}
/**
 * Sample call for cuis operation/method
 */
if ($cuis->cuis(new \StructType\Cuis()) !== false) {
    print_r($cuis->getResult());
} else {
    print_r($cuis->getLastError());
}
/**
 * Samples for Cufd ServiceType
 */
$cufd = new \ServiceType\Cufd($options);
/**
 * Sample call for cufd operation/method
 */
if ($cufd->cufd(new \StructType\Cufd()) !== false) {
    print_r($cufd->getResult());
} else {
    print_r($cufd->getLastError());
}
/**
 * Sample call for cufdMasivo operation/method
 */
if ($cufd->cufdMasivo(new \StructType\CufdMasivo()) !== false) {
    print_r($cufd->getResult());
} else {
    print_r($cufd->getLastError());
}
/**
 * Samples for Notifica ServiceType
 */
$notifica = new \ServiceType\Notifica($options);
/**
 * Sample call for notificaCertificadoRevocado operation/method
 */
if ($notifica->notificaCertificadoRevocado(new \StructType\NotificaCertificadoRevocado()) !== false) {
    print_r($notifica->getResult());
} else {
    print_r($notifica->getLastError());
}
