<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for respuestaListaRegistroCufdSoapDto StructType
 * @subpackage Structs
 */
class RespuestaListaRegistroCufdSoapDto extends AbstractStructBase
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigo;
    /**
     * The codigoControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoControl;
    /**
     * The codigoPuntoVenta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoPuntoVenta;
    /**
     * The codigoSucursal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoSucursal;
    /**
     * The cuis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cuis;
    /**
     * The direccion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $direccion;
    /**
     * The fechaVigencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaVigencia;
    /**
     * The mensajeServicioList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MensajeServicio[]
     */
    public $mensajeServicioList;
    /**
     * The transaccion
     * @var bool
     */
    public $transaccion;
    /**
     * Constructor method for respuestaListaRegistroCufdSoapDto
     * @uses RespuestaListaRegistroCufdSoapDto::setCodigo()
     * @uses RespuestaListaRegistroCufdSoapDto::setCodigoControl()
     * @uses RespuestaListaRegistroCufdSoapDto::setCodigoPuntoVenta()
     * @uses RespuestaListaRegistroCufdSoapDto::setCodigoSucursal()
     * @uses RespuestaListaRegistroCufdSoapDto::setCuis()
     * @uses RespuestaListaRegistroCufdSoapDto::setDireccion()
     * @uses RespuestaListaRegistroCufdSoapDto::setFechaVigencia()
     * @uses RespuestaListaRegistroCufdSoapDto::setMensajeServicioList()
     * @uses RespuestaListaRegistroCufdSoapDto::setTransaccion()
     * @param string $codigo
     * @param string $codigoControl
     * @param int $codigoPuntoVenta
     * @param int $codigoSucursal
     * @param string $cuis
     * @param string $direccion
     * @param string $fechaVigencia
     * @param \StructType\MensajeServicio[] $mensajeServicioList
     * @param bool $transaccion
     */
    public function __construct($codigo = null, $codigoControl = null, $codigoPuntoVenta = null, $codigoSucursal = null, $cuis = null, $direccion = null, $fechaVigencia = null, array $mensajeServicioList = array(), $transaccion = null)
    {
        $this
            ->setCodigo($codigo)
            ->setCodigoControl($codigoControl)
            ->setCodigoPuntoVenta($codigoPuntoVenta)
            ->setCodigoSucursal($codigoSucursal)
            ->setCuis($cuis)
            ->setDireccion($direccion)
            ->setFechaVigencia($fechaVigencia)
            ->setMensajeServicioList($mensajeServicioList)
            ->setTransaccion($transaccion);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get codigoControl value
     * @return string|null
     */
    public function getCodigoControl()
    {
        return $this->codigoControl;
    }
    /**
     * Set codigoControl value
     * @param string $codigoControl
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setCodigoControl($codigoControl = null)
    {
        // validation for constraint: string
        if (!is_null($codigoControl) && !is_string($codigoControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoControl, true), gettype($codigoControl)), __LINE__);
        }
        $this->codigoControl = $codigoControl;
        return $this;
    }
    /**
     * Get codigoPuntoVenta value
     * @return int|null
     */
    public function getCodigoPuntoVenta()
    {
        return $this->codigoPuntoVenta;
    }
    /**
     * Set codigoPuntoVenta value
     * @param int $codigoPuntoVenta
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setCodigoPuntoVenta($codigoPuntoVenta = null)
    {
        // validation for constraint: int
        if (!is_null($codigoPuntoVenta) && !(is_int($codigoPuntoVenta) || ctype_digit($codigoPuntoVenta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoPuntoVenta, true), gettype($codigoPuntoVenta)), __LINE__);
        }
        $this->codigoPuntoVenta = $codigoPuntoVenta;
        return $this;
    }
    /**
     * Get codigoSucursal value
     * @return int|null
     */
    public function getCodigoSucursal()
    {
        return $this->codigoSucursal;
    }
    /**
     * Set codigoSucursal value
     * @param int $codigoSucursal
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setCodigoSucursal($codigoSucursal = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSucursal) && !(is_int($codigoSucursal) || ctype_digit($codigoSucursal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSucursal, true), gettype($codigoSucursal)), __LINE__);
        }
        $this->codigoSucursal = $codigoSucursal;
        return $this;
    }
    /**
     * Get cuis value
     * @return string|null
     */
    public function getCuis()
    {
        return $this->cuis;
    }
    /**
     * Set cuis value
     * @param string $cuis
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setCuis($cuis = null)
    {
        // validation for constraint: string
        if (!is_null($cuis) && !is_string($cuis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cuis, true), gettype($cuis)), __LINE__);
        }
        $this->cuis = $cuis;
        return $this;
    }
    /**
     * Get direccion value
     * @return string|null
     */
    public function getDireccion()
    {
        return $this->direccion;
    }
    /**
     * Set direccion value
     * @param string $direccion
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setDireccion($direccion = null)
    {
        // validation for constraint: string
        if (!is_null($direccion) && !is_string($direccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccion, true), gettype($direccion)), __LINE__);
        }
        $this->direccion = $direccion;
        return $this;
    }
    /**
     * Get fechaVigencia value
     * @return string|null
     */
    public function getFechaVigencia()
    {
        return $this->fechaVigencia;
    }
    /**
     * Set fechaVigencia value
     * @param string $fechaVigencia
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setFechaVigencia($fechaVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigencia) && !is_string($fechaVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigencia, true), gettype($fechaVigencia)), __LINE__);
        }
        $this->fechaVigencia = $fechaVigencia;
        return $this;
    }
    /**
     * Get mensajeServicioList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MensajeServicio[]|null
     */
    public function getMensajeServicioList()
    {
        return isset($this->mensajeServicioList) ? $this->mensajeServicioList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMensajeServicioList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMensajeServicioList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMensajeServicioListForArrayConstraintsFromSetMensajeServicioList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $respuestaListaRegistroCufdSoapDtoMensajeServicioListItem) {
            // validation for constraint: itemType
            if (!$respuestaListaRegistroCufdSoapDtoMensajeServicioListItem instanceof \StructType\MensajeServicio) {
                $invalidValues[] = is_object($respuestaListaRegistroCufdSoapDtoMensajeServicioListItem) ? get_class($respuestaListaRegistroCufdSoapDtoMensajeServicioListItem) : sprintf('%s(%s)', gettype($respuestaListaRegistroCufdSoapDtoMensajeServicioListItem), var_export($respuestaListaRegistroCufdSoapDtoMensajeServicioListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mensajeServicioList property can only contain items of type \StructType\MensajeServicio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mensajeServicioList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MensajeServicio[] $mensajeServicioList
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setMensajeServicioList(array $mensajeServicioList = array())
    {
        // validation for constraint: array
        if ('' !== ($mensajeServicioListArrayErrorMessage = self::validateMensajeServicioListForArrayConstraintsFromSetMensajeServicioList($mensajeServicioList))) {
            throw new \InvalidArgumentException($mensajeServicioListArrayErrorMessage, __LINE__);
        }
        if (is_null($mensajeServicioList) || (is_array($mensajeServicioList) && empty($mensajeServicioList))) {
            unset($this->mensajeServicioList);
        } else {
            $this->mensajeServicioList = $mensajeServicioList;
        }
        return $this;
    }
    /**
     * Add item to mensajeServicioList value
     * @throws \InvalidArgumentException
     * @param \StructType\MensajeServicio $item
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function addToMensajeServicioList(\StructType\MensajeServicio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MensajeServicio) {
            throw new \InvalidArgumentException(sprintf('The mensajeServicioList property can only contain items of type \StructType\MensajeServicio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mensajeServicioList[] = $item;
        return $this;
    }
    /**
     * Get transaccion value
     * @return bool|null
     */
    public function getTransaccion()
    {
        return $this->transaccion;
    }
    /**
     * Set transaccion value
     * @param bool $transaccion
     * @return \StructType\RespuestaListaRegistroCufdSoapDto
     */
    public function setTransaccion($transaccion = null)
    {
        // validation for constraint: boolean
        if (!is_null($transaccion) && !is_bool($transaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($transaccion, true), gettype($transaccion)), __LINE__);
        }
        $this->transaccion = $transaccion;
        return $this;
    }
}
