<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for respuestaListaRegistroCuisSoapDto StructType
 * @subpackage Structs
 */
class RespuestaListaRegistroCuisSoapDto extends AbstractStructBase
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigo;
    /**
     * The codigoPuntoVenta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoPuntoVenta;
    /**
     * The codigoSucursal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoSucursal;
    /**
     * The fechaVigencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaVigencia;
    /**
     * The mensajeServicioList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MensajeServicio[]
     */
    public $mensajeServicioList;
    /**
     * The transaccion
     * @var bool
     */
    public $transaccion;
    /**
     * Constructor method for respuestaListaRegistroCuisSoapDto
     * @uses RespuestaListaRegistroCuisSoapDto::setCodigo()
     * @uses RespuestaListaRegistroCuisSoapDto::setCodigoPuntoVenta()
     * @uses RespuestaListaRegistroCuisSoapDto::setCodigoSucursal()
     * @uses RespuestaListaRegistroCuisSoapDto::setFechaVigencia()
     * @uses RespuestaListaRegistroCuisSoapDto::setMensajeServicioList()
     * @uses RespuestaListaRegistroCuisSoapDto::setTransaccion()
     * @param string $codigo
     * @param int $codigoPuntoVenta
     * @param int $codigoSucursal
     * @param string $fechaVigencia
     * @param \StructType\MensajeServicio[] $mensajeServicioList
     * @param bool $transaccion
     */
    public function __construct($codigo = null, $codigoPuntoVenta = null, $codigoSucursal = null, $fechaVigencia = null, array $mensajeServicioList = array(), $transaccion = null)
    {
        $this
            ->setCodigo($codigo)
            ->setCodigoPuntoVenta($codigoPuntoVenta)
            ->setCodigoSucursal($codigoSucursal)
            ->setFechaVigencia($fechaVigencia)
            ->setMensajeServicioList($mensajeServicioList)
            ->setTransaccion($transaccion);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\RespuestaListaRegistroCuisSoapDto
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get codigoPuntoVenta value
     * @return int|null
     */
    public function getCodigoPuntoVenta()
    {
        return $this->codigoPuntoVenta;
    }
    /**
     * Set codigoPuntoVenta value
     * @param int $codigoPuntoVenta
     * @return \StructType\RespuestaListaRegistroCuisSoapDto
     */
    public function setCodigoPuntoVenta($codigoPuntoVenta = null)
    {
        // validation for constraint: int
        if (!is_null($codigoPuntoVenta) && !(is_int($codigoPuntoVenta) || ctype_digit($codigoPuntoVenta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoPuntoVenta, true), gettype($codigoPuntoVenta)), __LINE__);
        }
        $this->codigoPuntoVenta = $codigoPuntoVenta;
        return $this;
    }
    /**
     * Get codigoSucursal value
     * @return int|null
     */
    public function getCodigoSucursal()
    {
        return $this->codigoSucursal;
    }
    /**
     * Set codigoSucursal value
     * @param int $codigoSucursal
     * @return \StructType\RespuestaListaRegistroCuisSoapDto
     */
    public function setCodigoSucursal($codigoSucursal = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSucursal) && !(is_int($codigoSucursal) || ctype_digit($codigoSucursal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSucursal, true), gettype($codigoSucursal)), __LINE__);
        }
        $this->codigoSucursal = $codigoSucursal;
        return $this;
    }
    /**
     * Get fechaVigencia value
     * @return string|null
     */
    public function getFechaVigencia()
    {
        return $this->fechaVigencia;
    }
    /**
     * Set fechaVigencia value
     * @param string $fechaVigencia
     * @return \StructType\RespuestaListaRegistroCuisSoapDto
     */
    public function setFechaVigencia($fechaVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigencia) && !is_string($fechaVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigencia, true), gettype($fechaVigencia)), __LINE__);
        }
        $this->fechaVigencia = $fechaVigencia;
        return $this;
    }
    /**
     * Get mensajeServicioList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MensajeServicio[]|null
     */
    public function getMensajeServicioList()
    {
        return isset($this->mensajeServicioList) ? $this->mensajeServicioList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMensajeServicioList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMensajeServicioList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMensajeServicioListForArrayConstraintsFromSetMensajeServicioList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $respuestaListaRegistroCuisSoapDtoMensajeServicioListItem) {
            // validation for constraint: itemType
            if (!$respuestaListaRegistroCuisSoapDtoMensajeServicioListItem instanceof \StructType\MensajeServicio) {
                $invalidValues[] = is_object($respuestaListaRegistroCuisSoapDtoMensajeServicioListItem) ? get_class($respuestaListaRegistroCuisSoapDtoMensajeServicioListItem) : sprintf('%s(%s)', gettype($respuestaListaRegistroCuisSoapDtoMensajeServicioListItem), var_export($respuestaListaRegistroCuisSoapDtoMensajeServicioListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mensajeServicioList property can only contain items of type \StructType\MensajeServicio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mensajeServicioList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MensajeServicio[] $mensajeServicioList
     * @return \StructType\RespuestaListaRegistroCuisSoapDto
     */
    public function setMensajeServicioList(array $mensajeServicioList = array())
    {
        // validation for constraint: array
        if ('' !== ($mensajeServicioListArrayErrorMessage = self::validateMensajeServicioListForArrayConstraintsFromSetMensajeServicioList($mensajeServicioList))) {
            throw new \InvalidArgumentException($mensajeServicioListArrayErrorMessage, __LINE__);
        }
        if (is_null($mensajeServicioList) || (is_array($mensajeServicioList) && empty($mensajeServicioList))) {
            unset($this->mensajeServicioList);
        } else {
            $this->mensajeServicioList = $mensajeServicioList;
        }
        return $this;
    }
    /**
     * Add item to mensajeServicioList value
     * @throws \InvalidArgumentException
     * @param \StructType\MensajeServicio $item
     * @return \StructType\RespuestaListaRegistroCuisSoapDto
     */
    public function addToMensajeServicioList(\StructType\MensajeServicio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MensajeServicio) {
            throw new \InvalidArgumentException(sprintf('The mensajeServicioList property can only contain items of type \StructType\MensajeServicio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mensajeServicioList[] = $item;
        return $this;
    }
    /**
     * Get transaccion value
     * @return bool|null
     */
    public function getTransaccion()
    {
        return $this->transaccion;
    }
    /**
     * Set transaccion value
     * @param bool $transaccion
     * @return \StructType\RespuestaListaRegistroCuisSoapDto
     */
    public function setTransaccion($transaccion = null)
    {
        // validation for constraint: boolean
        if (!is_null($transaccion) && !is_bool($transaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($transaccion, true), gettype($transaccion)), __LINE__);
        }
        $this->transaccion = $transaccion;
        return $this;
    }
}
