<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for respuestaCufd StructType
 * @subpackage Structs
 */
class RespuestaCufd extends ModelDto
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigo;
    /**
     * The codigoControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoControl;
    /**
     * The direccion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $direccion;
    /**
     * The fechaVigencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaVigencia;
    /**
     * The mensajesList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MensajeServicio[]
     */
    public $mensajesList;
    /**
     * The transaccion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $transaccion;
    /**
     * Constructor method for respuestaCufd
     * @uses RespuestaCufd::setCodigo()
     * @uses RespuestaCufd::setCodigoControl()
     * @uses RespuestaCufd::setDireccion()
     * @uses RespuestaCufd::setFechaVigencia()
     * @uses RespuestaCufd::setMensajesList()
     * @uses RespuestaCufd::setTransaccion()
     * @param string $codigo
     * @param string $codigoControl
     * @param string $direccion
     * @param string $fechaVigencia
     * @param \StructType\MensajeServicio[] $mensajesList
     * @param bool $transaccion
     */
    public function __construct($codigo = null, $codigoControl = null, $direccion = null, $fechaVigencia = null, array $mensajesList = array(), $transaccion = null)
    {
        $this
            ->setCodigo($codigo)
            ->setCodigoControl($codigoControl)
            ->setDireccion($direccion)
            ->setFechaVigencia($fechaVigencia)
            ->setMensajesList($mensajesList)
            ->setTransaccion($transaccion);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\RespuestaCufd
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get codigoControl value
     * @return string|null
     */
    public function getCodigoControl()
    {
        return $this->codigoControl;
    }
    /**
     * Set codigoControl value
     * @param string $codigoControl
     * @return \StructType\RespuestaCufd
     */
    public function setCodigoControl($codigoControl = null)
    {
        // validation for constraint: string
        if (!is_null($codigoControl) && !is_string($codigoControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoControl, true), gettype($codigoControl)), __LINE__);
        }
        $this->codigoControl = $codigoControl;
        return $this;
    }
    /**
     * Get direccion value
     * @return string|null
     */
    public function getDireccion()
    {
        return $this->direccion;
    }
    /**
     * Set direccion value
     * @param string $direccion
     * @return \StructType\RespuestaCufd
     */
    public function setDireccion($direccion = null)
    {
        // validation for constraint: string
        if (!is_null($direccion) && !is_string($direccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccion, true), gettype($direccion)), __LINE__);
        }
        $this->direccion = $direccion;
        return $this;
    }
    /**
     * Get fechaVigencia value
     * @return string|null
     */
    public function getFechaVigencia()
    {
        return $this->fechaVigencia;
    }
    /**
     * Set fechaVigencia value
     * @param string $fechaVigencia
     * @return \StructType\RespuestaCufd
     */
    public function setFechaVigencia($fechaVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigencia) && !is_string($fechaVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigencia, true), gettype($fechaVigencia)), __LINE__);
        }
        $this->fechaVigencia = $fechaVigencia;
        return $this;
    }
    /**
     * Get mensajesList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MensajeServicio[]|null
     */
    public function getMensajesList()
    {
        return isset($this->mensajesList) ? $this->mensajesList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMensajesList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMensajesList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMensajesListForArrayConstraintsFromSetMensajesList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $respuestaCufdMensajesListItem) {
            // validation for constraint: itemType
            if (!$respuestaCufdMensajesListItem instanceof \StructType\MensajeServicio) {
                $invalidValues[] = is_object($respuestaCufdMensajesListItem) ? get_class($respuestaCufdMensajesListItem) : sprintf('%s(%s)', gettype($respuestaCufdMensajesListItem), var_export($respuestaCufdMensajesListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mensajesList property can only contain items of type \StructType\MensajeServicio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mensajesList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MensajeServicio[] $mensajesList
     * @return \StructType\RespuestaCufd
     */
    public function setMensajesList(array $mensajesList = array())
    {
        // validation for constraint: array
        if ('' !== ($mensajesListArrayErrorMessage = self::validateMensajesListForArrayConstraintsFromSetMensajesList($mensajesList))) {
            throw new \InvalidArgumentException($mensajesListArrayErrorMessage, __LINE__);
        }
        if (is_null($mensajesList) || (is_array($mensajesList) && empty($mensajesList))) {
            unset($this->mensajesList);
        } else {
            $this->mensajesList = $mensajesList;
        }
        return $this;
    }
    /**
     * Add item to mensajesList value
     * @throws \InvalidArgumentException
     * @param \StructType\MensajeServicio $item
     * @return \StructType\RespuestaCufd
     */
    public function addToMensajesList(\StructType\MensajeServicio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MensajeServicio) {
            throw new \InvalidArgumentException(sprintf('The mensajesList property can only contain items of type \StructType\MensajeServicio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mensajesList[] = $item;
        return $this;
    }
    /**
     * Get transaccion value
     * @return bool|null
     */
    public function getTransaccion()
    {
        return $this->transaccion;
    }
    /**
     * Set transaccion value
     * @param bool $transaccion
     * @return \StructType\RespuestaCufd
     */
    public function setTransaccion($transaccion = null)
    {
        // validation for constraint: boolean
        if (!is_null($transaccion) && !is_bool($transaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($transaccion, true), gettype($transaccion)), __LINE__);
        }
        $this->transaccion = $transaccion;
        return $this;
    }
}
