<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mensajeServicio StructType
 * @subpackage Structs
 */
class MensajeServicio extends ModelDto
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigo;
    /**
     * The descripcion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descripcion;
    /**
     * Constructor method for mensajeServicio
     * @uses MensajeServicio::setCodigo()
     * @uses MensajeServicio::setDescripcion()
     * @param int $codigo
     * @param string $descripcion
     */
    public function __construct($codigo = null, $descripcion = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescripcion($descripcion);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\MensajeServicio
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\MensajeServicio
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
}
