<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Verificar ServiceType
 * @subpackage Services
 */
class Verificar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named verificarNit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VerificarNit $parameters
     * @return \StructType\VerificarNitResponse|bool
     */
    public function verificarNit(\StructType\VerificarNit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->verificarNit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named verificarComunicacion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VerificarComunicacion $parameters
     * @return \StructType\VerificarComunicacionResponse|bool
     */
    public function verificarComunicacion(\StructType\VerificarComunicacion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->verificarComunicacion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VerificarComunicacionResponse|\StructType\VerificarNitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
